/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atmos;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.atmos.AtmosConfiguration;
import org.apache.camel.component.atmos.AtmosEndpoint;
import org.apache.camel.component.atmos.util.AtmosOperation;
import org.apache.camel.component.atmos.validator.AtmosConfigurationValidator;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;

@Component(value="atmos")
public class AtmosComponent
extends DefaultComponent {
    @Metadata(label="security", secret=true)
    private String fullTokenId;
    @Metadata(label="security", secret=true)
    private String secretKey;
    @Metadata(label="advanced")
    private String uri;
    @Metadata(label="security")
    private boolean sslValidation;

    public AtmosComponent() {
    }

    public AtmosComponent(CamelContext context) {
        super(context);
    }

    @Override
    protected AtmosEndpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        AtmosConfiguration configuration = new AtmosConfiguration();
        String name = null;
        String operation = remaining;
        String[] parts = remaining.split("/");
        if (parts.length > 1) {
            name = parts[0];
            operation = parts[1];
        }
        configuration.setName(name);
        configuration.setOperation(AtmosOperation.valueOf(operation));
        configuration.setUri(parameters.get("uri") == null ? this.uri : (String)parameters.get("uri"));
        configuration.setSecretKey(parameters.get("secretKey") == null ? this.secretKey : (String)parameters.get("secretKey"));
        configuration.setLocalPath((String)parameters.get("localPath"));
        configuration.setRemotePath((String)parameters.get("remotePath"));
        configuration.setNewRemotePath((String)parameters.get("newRemotePath"));
        configuration.setQuery((String)parameters.get("query"));
        configuration.setFullTokenId(parameters.get("fullTokenId") == null ? this.fullTokenId : (String)parameters.get("fullTokenId"));
        configuration.setSslValidation(this.sslValidation);
        AtmosConfigurationValidator.validate(configuration);
        AtmosEndpoint endpoint = new AtmosEndpoint(uri, this, configuration);
        this.setProperties(endpoint, parameters);
        return endpoint;
    }

    public String getFullTokenId() {
        return this.fullTokenId;
    }

    public void setFullTokenId(String fullTokenId) {
        this.fullTokenId = fullTokenId;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public boolean isSslValidation() {
        return this.sslValidation;
    }

    public void setSslValidation(boolean sslValidation) {
        this.sslValidation = sslValidation;
    }
}

