/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import javax.activation.DataSource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import org.apache.camel.Attachment;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.http.common.DefaultHttpBinding;
import org.apache.camel.http.common.HttpMessage;
import org.apache.camel.impl.DefaultAttachment;

public final class AttachmentHttpBinding
extends DefaultHttpBinding {
    AttachmentHttpBinding() {
    }

    @Override
    protected void populateAttachments(HttpServletRequest request, HttpMessage message) {
        try {
            Collection<Part> parts = request.getParts();
            for (Part part : parts) {
                PartDataSource ds = new PartDataSource(part);
                DefaultAttachment attachment = new DefaultAttachment((DataSource)ds);
                for (String headerName : part.getHeaderNames()) {
                    for (String headerValue : part.getHeaders(headerName)) {
                        attachment.addHeader(headerName, headerValue);
                    }
                }
                message.addAttachmentObject(part.getName(), (Attachment)attachment);
            }
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Cannot populate attachments", (Throwable)e);
        }
    }

    public final class PartDataSource
    implements DataSource {
        private final Part part;

        PartDataSource(Part part) {
            this.part = part;
        }

        public String getSubmittedFileName() {
            return this.part.getSubmittedFileName();
        }

        public OutputStream getOutputStream() throws IOException {
            return null;
        }

        public String getName() {
            return this.part.getName();
        }

        public InputStream getInputStream() throws IOException {
            return this.part.getInputStream();
        }

        public String getContentType() {
            return this.part.getContentType();
        }
    }
}

