/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atmosphere.websocket;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class WebsocketEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":servicePath";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    @Override
    public boolean isEnabled(String scheme) {
        return "atmosphere-websocket".equals(scheme);
    }

    @Override
    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "servicePath", null, true, copy);
        uri = this.buildQueryParameters(uri, copy, encode);
        return uri;
    }

    @Override
    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    @Override
    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    @Override
    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(27);
        props.add("sendToAll");
        props.add("attachmentMultipartBinding");
        props.add("mapHttpMessageBody");
        props.add("servletName");
        props.add("useStreaming");
        props.add("bridgeErrorHandler");
        props.add("headerFilterStrategy");
        props.add("transferException");
        props.add("bridgeEndpoint");
        props.add("muteException");
        props.add("httpMethodRestrict");
        props.add("eagerCheckContentAvailable");
        props.add("httpBinding");
        props.add("matchOnUriPrefix");
        props.add("exchangePattern");
        props.add("chunked");
        props.add("mapHttpMessageFormUrlEncodedBody");
        props.add("fileNameExtWhitelist");
        props.add("async");
        props.add("responseBufferSize");
        props.add("lazyStartProducer");
        props.add("disableStreamCache");
        props.add("servicePath");
        props.add("mapHttpMessageHeaders");
        props.add("optionsEnabled");
        props.add("traceEnabled");
        props.add("exceptionHandler");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
    }
}

