/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atmosphere.websocket;

import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.atmosphere.websocket.WebsocketEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.atmosphere.websocket.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebsocketProducer
extends DefaultProducer {
    private static final transient Logger LOG = LoggerFactory.getLogger(WebsocketProducer.class);
    private static ExecutorService executor = Executors.newSingleThreadExecutor();

    public WebsocketProducer(WebsocketEndpoint endpoint) {
        super(endpoint);
    }

    @Override
    public WebsocketEndpoint getEndpoint() {
        return (WebsocketEndpoint)super.getEndpoint();
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        Message in = exchange.getIn();
        Object message = in.getBody();
        if (message == null) {
            LOG.debug("Ignoring a null message");
            return;
        }
        if (!(message instanceof String || message instanceof byte[] || message instanceof Reader || message instanceof InputStream)) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Using String for unexpected message type {}", message.getClass());
            }
            message = in.getBody(String.class);
        }
        if (message instanceof Reader) {
            message = in.getBody(String.class);
        } else if (message instanceof InputStream) {
            message = in.getBody(byte[].class);
        }
        LOG.debug("Sending to {}", message);
        if (this.getEndpoint().isSendToAll()) {
            LOG.debug("Sending to all -> {}", message);
            for (WebSocket websocket : this.getEndpoint().getWebSocketStore().getAllWebSockets()) {
                this.sendMessage(websocket, message);
            }
        } else if (in.getHeader("websocket.connectionKey.list") != null) {
            List connectionKeyList = in.getHeader("websocket.connectionKey.list", List.class);
            this.messageDistributor(connectionKeyList, message);
        } else {
            String connectionKey = in.getHeader("websocket.connectionKey", String.class);
            this.messageDistributor(Arrays.asList(connectionKey), message);
        }
    }

    private void messageDistributor(List<String> connectionKeyList, Object message) {
        if (connectionKeyList == null) {
            throw new IllegalArgumentException("Failed to send message to multiple connections; connetion key list is not set.");
        }
        ArrayList<String> notValidConnectionKeys = new ArrayList<String>();
        for (String connectionKey : connectionKeyList) {
            LOG.debug("Sending to connection key {} -> {}", (Object)connectionKey, message);
            this.sendMessage(this.getWebSocket(connectionKey, notValidConnectionKeys), message);
        }
        if (!notValidConnectionKeys.isEmpty()) {
            LOG.debug("Some connections have not received the message {}", message);
            this.getEndpoint().getWebsocketConsumer().sendNotDeliveredMessage(notValidConnectionKeys, message);
        }
    }

    private void sendMessage(final WebSocket websocket, final Object message) {
        if (websocket != null && message != null) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (message instanceof String) {
                            websocket.write((String)message);
                        } else if (message instanceof byte[]) {
                            websocket.write((byte[])message, 0, ((byte[])message).length);
                        } else {
                            LOG.warn("unexpected message type {}", message.getClass());
                        }
                    }
                    catch (Exception e) {
                        LOG.error("Error when writing to websocket", (Throwable)e);
                    }
                }
            });
        }
    }

    private WebSocket getWebSocket(String connectionKey, List<String> notValidConnectionKeys) {
        if (connectionKey == null) {
            throw new IllegalArgumentException("Failed to send message to single connection; connection key is not set.");
        }
        WebSocket websocket = this.getEndpoint().getWebSocketStore().getWebSocket(connectionKey);
        if (websocket == null) {
            notValidConnectionKeys.add(connectionKey);
            LOG.debug("Failed to send message to single connection; connetion key is not valid. {}", (Object)connectionKey);
        }
        return websocket;
    }
}

