/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.feed;

import java.util.Date;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.feed.EntryFilter;
import org.apache.camel.component.feed.FeedEndpoint;
import org.apache.camel.component.feed.FeedPollingConsumer;

public abstract class FeedEntryPollingConsumer
extends FeedPollingConsumer {
    protected int entryIndex;
    protected EntryFilter entryFilter;
    protected List list;
    protected boolean throttleEntries;
    protected Object feed;

    public FeedEntryPollingConsumer(FeedEndpoint endpoint, Processor processor, boolean filter, Date lastUpdate, boolean throttleEntries) {
        super(endpoint, processor);
        if (filter) {
            this.entryFilter = this.createEntryFilter(lastUpdate);
        }
        this.throttleEntries = throttleEntries;
    }

    @Override
    public int poll() throws Exception {
        if (this.feed == null) {
            this.feed = this.createFeed();
            this.populateList(this.feed);
        }
        int polledMessages = 0;
        while (this.hasNextEntry()) {
            Object entry = this.list.get(this.entryIndex--);
            ++polledMessages;
            boolean valid = true;
            if (this.entryFilter != null) {
                valid = this.entryFilter.isValidEntry(this.endpoint, this.feed, entry);
            }
            if (!valid) continue;
            Exchange exchange = this.endpoint.createExchange(this.feed, entry);
            this.getProcessor().process(exchange);
            if (!this.throttleEntries) continue;
            return polledMessages;
        }
        this.feed = null;
        this.resetList();
        return polledMessages;
    }

    protected abstract EntryFilter createEntryFilter(Date var1);

    protected abstract void resetList();

    protected abstract void populateList(Object var1) throws Exception;

    private boolean hasNextEntry() {
        return this.entryIndex >= 0;
    }
}

