/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.feed;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.feed.FeedEndpoint;
import org.apache.camel.support.ScheduledPollConsumer;

public abstract class FeedPollingConsumer
extends ScheduledPollConsumer {
    public static final long DEFAULT_CONSUMER_DELAY = 60000L;
    protected final FeedEndpoint endpoint;

    public FeedPollingConsumer(FeedEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.endpoint = endpoint;
    }

    @Override
    protected int poll() throws Exception {
        Object feed = this.createFeed();
        if (feed != null) {
            Exchange exchange = this.endpoint.createExchange(feed);
            this.getProcessor().process(exchange);
            return 1;
        }
        return 0;
    }

    protected abstract Object createFeed() throws Exception;
}

