/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.buffer;

import io.atomix.catalyst.buffer.Buffer;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.buffer.Bytes;
import io.atomix.catalyst.buffer.CatalystIOException;
import io.atomix.catalyst.buffer.UnsafeHeapBuffer;
import io.atomix.catalyst.buffer.UnsafeHeapBytes;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class OutputStreamBufferOutput
implements BufferOutput<BufferOutput<?>> {
    private final DataOutputStream os;

    public OutputStreamBufferOutput(OutputStream os) {
        this(new DataOutputStream(os));
    }

    public OutputStreamBufferOutput(DataOutputStream os) {
        if (os == null) {
            throw new NullPointerException("output stream cannot be null");
        }
        this.os = os;
    }

    @Override
    public BufferOutput<?> write(Bytes bytes) {
        if (bytes instanceof UnsafeHeapBytes) {
            try {
                this.os.write(bytes.array());
            }
            catch (IOException e) {
                throw new CatalystIOException(e);
            }
        }
        byte[] buffer = new byte[(int)bytes.size()];
        bytes.read(0L, buffer, 0L, (long)buffer.length);
        try {
            this.os.write(buffer);
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
        return this;
    }

    @Override
    public BufferOutput<?> write(byte[] bytes) {
        try {
            this.os.write(bytes);
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
        return this;
    }

    @Override
    public BufferOutput<?> write(Bytes bytes, long offset, long length) {
        if (bytes instanceof UnsafeHeapBytes) {
            try {
                this.os.write(((UnsafeHeapBytes)bytes).array(), (int)offset, (int)length);
            }
            catch (IOException e) {
                throw new CatalystIOException(e);
            }
        }
        byte[] buffer = new byte[(int)bytes.size()];
        bytes.read(0L, buffer, 0L, (long)buffer.length);
        try {
            this.os.write(buffer, (int)offset, (int)length);
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
        return this;
    }

    @Override
    public BufferOutput<?> write(byte[] bytes, long offset, long length) {
        try {
            this.os.write(bytes, (int)offset, (int)length);
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
        return this;
    }

    @Override
    public BufferOutput<?> write(Buffer buffer) {
        if (buffer instanceof UnsafeHeapBuffer) {
            try {
                this.os.write(((UnsafeHeapBuffer)buffer).array());
            }
            catch (IOException e) {
                throw new CatalystIOException(e);
            }
        }
        byte[] bytes = new byte[(int)buffer.remaining()];
        buffer.read(bytes);
        try {
            this.os.write(bytes);
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
        return this;
    }

    @Override
    public BufferOutput<?> writeByte(int b) {
        try {
            this.os.writeByte(b);
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
        return this;
    }

    @Override
    public BufferOutput<?> writeUnsignedByte(int b) {
        try {
            this.os.writeByte(b);
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
        return this;
    }

    @Override
    public BufferOutput<?> writeChar(char c) {
        try {
            this.os.writeChar(c);
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
        return this;
    }

    @Override
    public BufferOutput<?> writeShort(short s) {
        try {
            this.os.writeShort(s);
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
        return this;
    }

    @Override
    public BufferOutput<?> writeUnsignedShort(int s) {
        try {
            this.os.writeShort(s);
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
        return this;
    }

    @Override
    public BufferOutput<?> writeMedium(int m) {
        try {
            this.os.writeByte((byte)(m >>> 16));
            this.os.writeByte((byte)(m >>> 8));
            this.os.writeByte((byte)m);
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
        return this;
    }

    @Override
    public BufferOutput<?> writeUnsignedMedium(int m) {
        return this.writeMedium(m);
    }

    @Override
    public BufferOutput<?> writeInt(int i) {
        try {
            this.os.writeInt(i);
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
        return this;
    }

    @Override
    public BufferOutput<?> writeUnsignedInt(long i) {
        try {
            this.os.writeInt((int)i);
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
        return this;
    }

    @Override
    public BufferOutput<?> writeLong(long l) {
        try {
            this.os.writeLong(l);
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
        return this;
    }

    @Override
    public BufferOutput<?> writeFloat(float f) {
        try {
            this.os.writeFloat(f);
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
        return this;
    }

    @Override
    public BufferOutput<?> writeDouble(double d) {
        try {
            this.os.writeDouble(d);
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
        return this;
    }

    @Override
    public BufferOutput<?> writeBoolean(boolean b) {
        try {
            this.os.writeBoolean(b);
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
        return this;
    }

    @Override
    public BufferOutput<?> writeString(String s) {
        return this.writeString(s, Charset.defaultCharset());
    }

    @Override
    public BufferOutput<?> writeString(String s, Charset charset) {
        if (s == null) {
            return this.writeBoolean(Boolean.FALSE);
        }
        byte[] bytes = s.getBytes(charset);
        this.writeBoolean(Boolean.TRUE);
        return this.writeUnsignedShort(bytes.length).write(bytes, 0L, (long)bytes.length);
    }

    @Override
    public BufferOutput<?> writeUTF8(String s) {
        return this.writeString(s, StandardCharsets.UTF_8);
    }

    @Override
    public BufferOutput<?> flush() {
        try {
            this.os.flush();
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
        return this;
    }

    @Override
    public void close() {
        try {
            this.os.close();
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
    }
}

