/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.error;

import io.atomix.copycat.error.ApplicationException;
import io.atomix.copycat.error.CommandException;
import io.atomix.copycat.error.ConfigurationException;
import io.atomix.copycat.error.CopycatException;
import io.atomix.copycat.error.IllegalMemberStateException;
import io.atomix.copycat.error.InternalException;
import io.atomix.copycat.error.NoLeaderException;
import io.atomix.copycat.error.QueryException;
import io.atomix.copycat.error.UnknownSessionException;

public interface CopycatError {
    public static CopycatError forId(int id) {
        switch (id) {
            case 1: {
                return Type.NO_LEADER_ERROR;
            }
            case 2: {
                return Type.QUERY_ERROR;
            }
            case 3: {
                return Type.COMMAND_ERROR;
            }
            case 4: {
                return Type.APPLICATION_ERROR;
            }
            case 5: {
                return Type.ILLEGAL_MEMBER_STATE_ERROR;
            }
            case 6: {
                return Type.UNKNOWN_SESSION_ERROR;
            }
            case 7: {
                return Type.INTERNAL_ERROR;
            }
            case 8: {
                return Type.CONFIGURATION_ERROR;
            }
        }
        throw new IllegalArgumentException("invalid error identifier: " + id);
    }

    public byte id();

    public CopycatException createException();

    public static enum Type implements CopycatError
    {
        NO_LEADER_ERROR(1){

            @Override
            public CopycatException createException() {
                return new NoLeaderException("not the leader", new Object[0]);
            }
        }
        ,
        QUERY_ERROR(2){

            @Override
            public CopycatException createException() {
                return new QueryException("failed to obtain read quorum", new Object[0]);
            }
        }
        ,
        COMMAND_ERROR(3){

            @Override
            public CopycatException createException() {
                return new CommandException("failed to obtain write quorum", new Object[0]);
            }
        }
        ,
        APPLICATION_ERROR(4){

            @Override
            public CopycatException createException() {
                return new ApplicationException("an application error occurred", new Object[0]);
            }
        }
        ,
        ILLEGAL_MEMBER_STATE_ERROR(5){

            @Override
            public CopycatException createException() {
                return new IllegalMemberStateException("illegal member state", new Object[0]);
            }
        }
        ,
        UNKNOWN_SESSION_ERROR(6){

            @Override
            public CopycatException createException() {
                return new UnknownSessionException("unknown member session", new Object[0]);
            }
        }
        ,
        INTERNAL_ERROR(7){

            @Override
            public CopycatException createException() {
                return new InternalException("internal Raft error", new Object[0]);
            }
        }
        ,
        CONFIGURATION_ERROR(8){

            @Override
            public CopycatException createException() {
                return new ConfigurationException("configuration failed", new Object[0]);
            }
        };

        private final byte id;

        private Type(int id) {
            this.id = (byte)id;
        }

        @Override
        public byte id() {
            return this.id;
        }
    }
}

