/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.protocol;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.protocol.AbstractRequest;
import java.util.Objects;

public class RegisterRequest
extends AbstractRequest {
    private String client;
    private long timeout;

    public static Builder builder() {
        return new Builder(new RegisterRequest());
    }

    public static Builder builder(RegisterRequest request) {
        return new Builder(request);
    }

    public String client() {
        return this.client;
    }

    public long timeout() {
        return this.timeout;
    }

    @Override
    public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        super.writeObject(buffer, serializer);
        buffer.writeString(this.client);
        buffer.writeLong(this.timeout);
    }

    @Override
    public void readObject(BufferInput<?> buffer, Serializer serializer) {
        super.readObject(buffer, serializer);
        this.client = buffer.readString();
        this.timeout = buffer.readLong();
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.client);
    }

    public boolean equals(Object object) {
        if (object instanceof RegisterRequest) {
            RegisterRequest request = (RegisterRequest)object;
            return request.client.equals(this.client) && request.timeout == this.timeout;
        }
        return false;
    }

    public String toString() {
        return String.format("%s[client=%s]", this.getClass().getSimpleName(), this.client);
    }

    public static class Builder
    extends AbstractRequest.Builder<Builder, RegisterRequest> {
        protected Builder(RegisterRequest request) {
            super(request);
        }

        public Builder withClient(String client) {
            ((RegisterRequest)this.request).client = Assert.notNull(client, "client");
            return this;
        }

        public Builder withTimeout(long timeout) {
            ((RegisterRequest)this.request).timeout = Assert.arg(timeout, timeout >= -1L, "timeout must be -1 or greater", new Object[0]);
            return this;
        }

        @Override
        public RegisterRequest build() {
            super.build();
            Assert.stateNot(((RegisterRequest)this.request).client == null, "client cannot be null", new Object[0]);
            return (RegisterRequest)this.request;
        }
    }
}

