/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.protocol;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.transport.Address;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.error.CopycatError;
import io.atomix.copycat.protocol.AbstractResponse;
import io.atomix.copycat.protocol.Response;
import java.util.Collection;
import java.util.Objects;

public class RegisterResponse
extends AbstractResponse {
    private long session;
    private Address leader;
    private Collection<Address> members;
    private long timeout;

    public static Builder builder() {
        return new Builder(new RegisterResponse());
    }

    public static Builder builder(RegisterResponse response) {
        return new Builder(response);
    }

    public long session() {
        return this.session;
    }

    public Address leader() {
        return this.leader;
    }

    public Collection<Address> members() {
        return this.members;
    }

    public long timeout() {
        return this.timeout;
    }

    @Override
    public void readObject(BufferInput<?> buffer, Serializer serializer) {
        this.status = Response.Status.forId(buffer.readByte());
        if (this.status == Response.Status.OK) {
            this.error = null;
            this.session = buffer.readLong();
            this.timeout = buffer.readLong();
            this.leader = (Address)serializer.readObject(buffer);
            this.members = (Collection)serializer.readObject(buffer);
        } else {
            this.error = CopycatError.forId(buffer.readByte());
            this.session = 0L;
            this.members = null;
        }
    }

    @Override
    public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        buffer.writeByte(this.status.id());
        if (this.status == Response.Status.OK) {
            buffer.writeLong(this.session);
            buffer.writeLong(this.timeout);
            serializer.writeObject(this.leader, buffer);
            serializer.writeObject(this.members, buffer);
        } else {
            buffer.writeByte(this.error.id());
        }
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getClass(), this.status, this.session, this.leader, this.members});
    }

    public boolean equals(Object object) {
        if (object instanceof RegisterResponse) {
            RegisterResponse response = (RegisterResponse)object;
            return response.status == this.status && response.session == this.session && (response.leader == null && this.leader == null || response.leader != null && this.leader != null && response.leader.equals(this.leader)) && (response.members == null && this.members == null || response.members != null && this.members != null && response.members.equals(this.members)) && response.timeout == this.timeout;
        }
        return false;
    }

    @Override
    public String toString() {
        return String.format("%s[status=%s, error=%s, session=%d, leader=%s, members=%s]", new Object[]{this.getClass().getSimpleName(), this.status, this.error, this.session, this.leader, this.members});
    }

    public static class Builder
    extends AbstractResponse.Builder<Builder, RegisterResponse> {
        protected Builder(RegisterResponse response) {
            super(response);
        }

        public Builder withSession(long session) {
            ((RegisterResponse)this.response).session = Assert.argNot(session, session < 1L, "session must be positive", new Object[0]);
            return this;
        }

        public Builder withLeader(Address leader) {
            ((RegisterResponse)this.response).leader = leader;
            return this;
        }

        public Builder withMembers(Collection<Address> members) {
            ((RegisterResponse)this.response).members = Assert.notNull(members, "members");
            return this;
        }

        public Builder withTimeout(long timeout) {
            ((RegisterResponse)this.response).timeout = Assert.argNot(timeout, timeout <= 0L, "timeout must be positive", new Object[0]);
            return this;
        }

        @Override
        public RegisterResponse build() {
            super.build();
            Assert.stateNot(((RegisterResponse)this.response).status == Response.Status.OK && ((RegisterResponse)this.response).members == null, "members cannot be null", new Object[0]);
            Assert.stateNot(((RegisterResponse)this.response).status == Response.Status.OK && ((RegisterResponse)this.response).timeout <= 0L, "timeout must be positive", new Object[0]);
            return (RegisterResponse)this.response;
        }
    }
}

