/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.protocol;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.error.CopycatError;
import io.atomix.copycat.protocol.AbstractResponse;
import io.atomix.copycat.protocol.Response;
import java.util.Objects;

public class AppendResponse
extends AbstractResponse {
    private long term;
    private boolean succeeded;
    private long logIndex;

    public static Builder builder() {
        return new Builder(new AppendResponse());
    }

    public static Builder builder(AppendResponse response) {
        return new Builder(response);
    }

    public long term() {
        return this.term;
    }

    public boolean succeeded() {
        return this.succeeded;
    }

    public long logIndex() {
        return this.logIndex;
    }

    public void readObject(BufferInput buffer, Serializer serializer) {
        this.status = Response.Status.forId(buffer.readByte());
        if (this.status == Response.Status.OK) {
            this.error = null;
            this.term = buffer.readLong();
            this.succeeded = buffer.readBoolean();
            this.logIndex = buffer.readLong();
        } else {
            this.error = CopycatError.forId(buffer.readByte());
        }
    }

    public void writeObject(BufferOutput buffer, Serializer serializer) {
        buffer.writeByte(this.status.id());
        if (this.status == Response.Status.OK) {
            buffer.writeLong(this.term).writeBoolean(this.succeeded).writeLong(this.logIndex);
        } else {
            buffer.writeByte(this.error.id());
        }
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getClass(), this.status, this.term, this.succeeded, this.logIndex});
    }

    public boolean equals(Object object) {
        if (object instanceof AppendResponse) {
            AppendResponse response = (AppendResponse)object;
            return response.status == this.status && response.term == this.term && response.succeeded == this.succeeded && response.logIndex == this.logIndex;
        }
        return false;
    }

    @Override
    public String toString() {
        return String.format("%s[status=%s, error=%s, term=%d, succeeded=%b, logIndex=%d]", new Object[]{this.getClass().getSimpleName(), this.status, this.error, this.term, this.succeeded, this.logIndex});
    }

    public static class Builder
    extends AbstractResponse.Builder<Builder, AppendResponse> {
        protected Builder(AppendResponse response) {
            super(response);
        }

        public Builder withTerm(long term) {
            ((AppendResponse)this.response).term = Assert.argNot(term, term <= 0L, "term must be positive", new Object[0]);
            return this;
        }

        public Builder withSucceeded(boolean succeeded) {
            ((AppendResponse)this.response).succeeded = succeeded;
            return this;
        }

        public Builder withLogIndex(long index) {
            ((AppendResponse)this.response).logIndex = Assert.argNot(index, index < 0L, "term must not be negative", new Object[0]);
            return this;
        }

        @Override
        public AppendResponse build() {
            super.build();
            if (((AppendResponse)this.response).status == Response.Status.OK) {
                Assert.stateNot(((AppendResponse)this.response).term <= 0L, "term must be positive", new Object[0]);
                Assert.stateNot(((AppendResponse)this.response).logIndex < 0L, "log index must be positive", new Object[0]);
            }
            return (AppendResponse)this.response;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.response);
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof Builder && ((AppendResponse)((Builder)object).response).equals(this.response);
        }

        @Override
        public String toString() {
            return String.format("%s[response=%s]", this.getClass().getCanonicalName(), this.response);
        }
    }
}

