/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.protocol;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.protocol.AbstractRequest;
import java.util.Objects;

public class PollRequest
extends AbstractRequest {
    private long term = -1L;
    private int candidate;
    private long logIndex = -1L;
    private long logTerm = -1L;

    public static Builder builder() {
        return new Builder(new PollRequest());
    }

    public static Builder builder(PollRequest request) {
        return new Builder(request);
    }

    public long term() {
        return this.term;
    }

    public int candidate() {
        return this.candidate;
    }

    public long logIndex() {
        return this.logIndex;
    }

    public long logTerm() {
        return this.logTerm;
    }

    @Override
    public void readObject(BufferInput<?> buffer, Serializer serializer) {
        this.term = buffer.readLong();
        this.candidate = buffer.readInt();
        this.logIndex = buffer.readLong();
        this.logTerm = buffer.readLong();
    }

    @Override
    public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        buffer.writeLong(this.term).writeInt(this.candidate).writeLong(this.logIndex).writeLong(this.logTerm);
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.term, this.candidate, this.logIndex, this.logTerm);
    }

    public boolean equals(Object object) {
        if (object instanceof PollRequest) {
            PollRequest request = (PollRequest)object;
            return request.term == this.term && request.candidate == this.candidate && request.logIndex == this.logIndex && request.logTerm == this.logTerm;
        }
        return false;
    }

    public String toString() {
        return String.format("%s[term=%d, candidate=%s, logIndex=%d, logTerm=%d]", this.getClass().getSimpleName(), this.term, this.candidate, this.logIndex, this.logTerm);
    }

    public static class Builder
    extends AbstractRequest.Builder<Builder, PollRequest> {
        protected Builder(PollRequest request) {
            super(request);
        }

        public Builder withTerm(long term) {
            ((PollRequest)this.request).term = Assert.argNot(term, term < 0L, "term must not be negative", new Object[0]);
            return this;
        }

        public Builder withCandidate(int candidate) {
            ((PollRequest)this.request).candidate = candidate;
            return this;
        }

        public Builder withLogIndex(long index) {
            ((PollRequest)this.request).logIndex = Assert.argNot(index, index < 0L, "log index must not be negative", new Object[0]);
            return this;
        }

        public Builder withLogTerm(long term) {
            ((PollRequest)this.request).logTerm = Assert.argNot(term, term < 0L, "log term must not be negative", new Object[0]);
            return this;
        }

        @Override
        public PollRequest build() {
            super.build();
            Assert.stateNot(((PollRequest)this.request).term < 0L, "term must not be negative", new Object[0]);
            Assert.stateNot(((PollRequest)this.request).logIndex < 0L, "log index must not be negative", new Object[0]);
            Assert.stateNot(((PollRequest)this.request).logTerm < 0L, "log term must not be negative", new Object[0]);
            return (PollRequest)this.request;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.request);
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof Builder && ((PollRequest)((Builder)object).request).equals(this.request);
        }

        @Override
        public String toString() {
            return String.format("%s[request=%s]", this.getClass().getCanonicalName(), this.request);
        }
    }
}

