/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.state;

import io.atomix.catalyst.transport.Connection;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.server.session.ServerSession;
import io.atomix.copycat.server.session.SessionListener;
import io.atomix.copycat.server.session.Sessions;
import io.atomix.copycat.server.state.ServerContext;
import io.atomix.copycat.server.state.ServerSessionContext;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

class ServerSessionManager
implements Sessions {
    private final Map<String, Connection> connections = new ConcurrentHashMap<String, Connection>();
    final Map<Long, ServerSessionContext> sessions = new ConcurrentHashMap<Long, ServerSessionContext>();
    final Map<String, ServerSessionContext> clients = new ConcurrentHashMap<String, ServerSessionContext>();
    final Set<SessionListener> listeners = new HashSet<SessionListener>();
    private final ServerContext context;

    public ServerSessionManager(ServerContext context) {
        this.context = Assert.notNull(context, "context");
    }

    @Override
    public ServerSession session(long sessionId) {
        return this.sessions.get(sessionId);
    }

    @Override
    public Sessions addListener(SessionListener listener) {
        this.listeners.add(Assert.notNull(listener, "listener"));
        return this;
    }

    @Override
    public Sessions removeListener(SessionListener listener) {
        this.listeners.remove(Assert.notNull(listener, "listener"));
        return this;
    }

    ServerSessionManager registerConnection(String client, Connection connection) {
        ServerSessionContext session = this.clients.get(client);
        if (session != null) {
            session.setConnection(connection);
        }
        this.connections.put(client, connection);
        return this;
    }

    ServerSessionManager unregisterConnection(Connection connection) {
        Iterator<Map.Entry<String, Connection>> iterator = this.connections.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Connection> entry = iterator.next();
            if (!entry.getValue().equals(connection)) continue;
            ServerSessionContext session = this.clients.get(entry.getKey());
            if (session != null) {
                session.setConnection(null);
            }
            iterator.remove();
        }
        return this;
    }

    ServerSessionContext registerSession(ServerSessionContext session) {
        ServerSessionContext oldSession = this.clients.remove(session.client());
        if (oldSession != null) {
            this.sessions.remove(oldSession.id());
        }
        session.setConnection(this.connections.get(session.client()));
        this.sessions.put(session.id(), session);
        this.clients.put(session.client(), session);
        return oldSession;
    }

    ServerSessionContext unregisterSession(long sessionId) {
        ServerSessionContext session = this.sessions.remove(sessionId);
        if (session != null) {
            this.clients.remove(session.client(), session);
            this.connections.remove(session.client(), session.getConnection());
        }
        return session;
    }

    ServerSessionContext getSession(long sessionId) {
        return this.sessions.get(sessionId);
    }

    ServerSessionContext getSession(String clientId) {
        return this.clients.get(clientId);
    }

    @Override
    public Iterator<ServerSession> iterator() {
        return this.sessions.values().iterator();
    }
}

