/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atomix;

import io.atomix.Atomix;
import io.atomix.catalyst.transport.Address;
import io.atomix.catalyst.transport.netty.NettyTransport;
import io.atomix.resource.ReadConsistency;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.spi.UriParam;
import org.apache.camel.util.ObjectHelper;

public class AtomixConfiguration<T extends Atomix>
implements Cloneable {
    @UriParam
    private Atomix atomix;
    @UriParam(javaType="java.lang.String")
    private List<Address> nodes = Collections.emptyList();
    @UriParam(defaultValue="io.atomix.catalyst.transport.netty.NettyTransport")
    private String transportClassName = NettyTransport.class.getName();
    @UriParam
    private String configurationUri;
    @UriParam(label="advanced")
    private ReadConsistency readConsistency;
    @UriParam(label="advanced")
    private Properties defaultResourceConfig;
    @UriParam(label="advanced")
    private Properties defaultResourceOptions;
    @UriParam(label="advanced", prefix="resource.config")
    private Map<String, Properties> resourceConfigs;
    @UriParam(label="advanced", prefix="resource.options")
    private Map<String, Properties> resourceOptions;
    @UriParam(label="advanced", defaultValue="false")
    private boolean ephemeral;

    protected AtomixConfiguration() {
    }

    public Atomix getAtomix() {
        return this.atomix;
    }

    public void setAtomix(Atomix client) {
        this.atomix = client;
    }

    public List<Address> getNodes() {
        return this.nodes;
    }

    public void setNodes(List<Address> nodes) {
        this.nodes = ObjectHelper.notNull(nodes, "Atomix Nodes");
    }

    public void setNodes(String nodes) {
        if (ObjectHelper.isNotEmpty(nodes)) {
            this.setNodes(Stream.of(nodes.split(",")).map(Address::new).collect(Collectors.toList()));
        }
    }

    public String getTransportClassName() {
        return this.transportClassName;
    }

    public void setTransportClassName(String transportClassName) {
        this.transportClassName = transportClassName;
    }

    public String getConfigurationUri() {
        return this.configurationUri;
    }

    public void setConfigurationUri(String configurationUri) {
        this.configurationUri = configurationUri;
    }

    public ReadConsistency getReadConsistency() {
        return this.readConsistency;
    }

    public void setReadConsistency(ReadConsistency readConsistency) {
        this.readConsistency = readConsistency;
    }

    public Properties getDefaultResourceConfig() {
        return this.defaultResourceConfig;
    }

    public void setDefaultResourceConfig(Properties defaultResourceConfig) {
        this.defaultResourceConfig = defaultResourceConfig;
    }

    public Properties getDefaultResourceOptions() {
        return this.defaultResourceOptions;
    }

    public void setDefaultResourceOptions(Properties defaultResourceOptions) {
        this.defaultResourceOptions = defaultResourceOptions;
    }

    public Map<String, Properties> getResourceConfigs() {
        return this.resourceConfigs;
    }

    public void setResourceConfigs(Map<String, Properties> resourceConfigs) {
        this.resourceConfigs = resourceConfigs;
    }

    public void addResourceConfig(String name, Properties config) {
        if (this.resourceConfigs == null) {
            this.resourceConfigs = new HashMap<String, Properties>();
        }
        this.resourceConfigs.put(name, config);
    }

    public Properties getResourceConfig(String name) {
        Properties properties = null;
        if (this.resourceConfigs != null) {
            Properties props = this.resourceConfigs.getOrDefault(name, this.defaultResourceConfig);
            if (props != null) {
                properties = new Properties(props);
            }
        } else if (this.defaultResourceConfig != null) {
            properties = new Properties(this.defaultResourceConfig);
        }
        if (properties == null) {
            properties = new Properties();
        }
        return properties;
    }

    public Map<String, Properties> getResourceOptions() {
        return this.resourceOptions;
    }

    public void setResourceOptions(Map<String, Properties> resourceOptions) {
        this.resourceOptions = resourceOptions;
    }

    public void addResourceOption(String name, Properties config) {
        if (this.resourceOptions == null) {
            this.resourceOptions = new HashMap<String, Properties>();
        }
        this.resourceOptions.put(name, config);
    }

    public Properties getResourceOptions(String name) {
        Properties properties = null;
        if (this.resourceOptions != null) {
            Properties props = this.resourceOptions.getOrDefault(name, this.defaultResourceOptions);
            if (props != null) {
                properties = new Properties(props);
            }
        } else if (this.defaultResourceOptions != null) {
            properties = new Properties(this.defaultResourceOptions);
        }
        if (properties == null) {
            properties = new Properties();
        }
        return properties;
    }

    public boolean isEphemeral() {
        return this.ephemeral;
    }

    public void setEphemeral(boolean ephemeral) {
        this.ephemeral = ephemeral;
    }
}

