/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atomix.client;

import io.atomix.AtomixClient;
import io.atomix.catalyst.transport.Address;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.component.atomix.AtomixConfiguration;
import org.apache.camel.component.atomix.client.AtomixClientConfiguration;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.util.PropertiesHelper;

public abstract class AbstractAtomixClientComponent<C extends AtomixClientConfiguration>
extends DefaultComponent {
    protected AbstractAtomixClientComponent() {
    }

    protected AbstractAtomixClientComponent(CamelContext camelContext) {
        super(camelContext);
    }

    public AtomixClient getAtomix() {
        return (AtomixClient)((AtomixConfiguration)this.getComponentConfiguration()).getAtomix();
    }

    @Metadata
    public void setAtomix(AtomixClient client) {
        ((AtomixConfiguration)this.getComponentConfiguration()).setAtomix(client);
    }

    public List<Address> getNodes() {
        return ((AtomixConfiguration)this.getComponentConfiguration()).getNodes();
    }

    @Metadata
    public void setNodes(List<Address> nodes) {
        ((AtomixConfiguration)this.getComponentConfiguration()).setNodes(nodes);
    }

    public void setNodes(String nodes) {
        ((AtomixConfiguration)this.getComponentConfiguration()).setNodes(nodes);
    }

    public String getConfigurationUri() {
        return ((AtomixConfiguration)this.getComponentConfiguration()).getConfigurationUri();
    }

    @Metadata
    public void setConfigurationUri(String configurationUri) {
        ((AtomixConfiguration)this.getComponentConfiguration()).setConfigurationUri(configurationUri);
    }

    protected C setConfigurationProperties(C configuration, Map<String, Object> parameters) {
        Map<String, Object> configs = PropertiesHelper.extractProperties(parameters, "resource.config.");
        for (Map.Entry<String, Object> entry : configs.entrySet()) {
            String ref = (String)entry.getValue();
            if (!EndpointHelper.isReferenceParameter(ref)) {
                throw new IllegalArgumentException("The option resource.config." + ref + " should be a reference");
            }
            ((AtomixConfiguration)configuration).addResourceConfig(entry.getKey(), EndpointHelper.resolveReferenceParameter(this.getCamelContext(), ref, Properties.class));
        }
        Map<String, Object> options = PropertiesHelper.extractProperties(parameters, "resource.options.");
        for (Map.Entry<String, Object> entry : options.entrySet()) {
            String ref = (String)entry.getValue();
            if (!EndpointHelper.isReferenceParameter(ref)) {
                throw new IllegalArgumentException("The option resource.options." + ref + " should be a reference");
            }
            ((AtomixConfiguration)configuration).addResourceOption(entry.getKey(), EndpointHelper.resolveReferenceParameter(this.getCamelContext(), ref, Properties.class));
        }
        return configuration;
    }

    protected abstract C getComponentConfiguration();
}

