/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atomix.client;

import io.atomix.resource.Resource;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Message;
import org.apache.camel.component.atomix.client.AbstractAtomixClientEndpoint;
import org.apache.camel.component.atomix.client.AtomixClientConfiguration;
import org.apache.camel.support.HeaderSelectorProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAtomixClientProducer<E extends AbstractAtomixClientEndpoint, R extends Resource>
extends HeaderSelectorProducer {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAtomixClientProducer.class);
    private ConcurrentMap<String, R> resources = new ConcurrentHashMap<String, R>();

    protected AbstractAtomixClientProducer(E endpoint, String defaultHeader) {
        super((Endpoint)endpoint, "CamelAtomixResourceAction", defaultHeader);
    }

    protected E getAtomixEndpoint() {
        return (E)((AbstractAtomixClientEndpoint)super.getEndpoint());
    }

    protected void processResult(Message message, AsyncCallback callback, Object result) {
        if (result != null && !(result instanceof Void)) {
            message.setHeader("CamelAtomixResourceActionHasResult", true);
            String resultHeader = ((AtomixClientConfiguration)((AbstractAtomixClientEndpoint)this.getAtomixEndpoint()).getConfiguration()).getResultHeader();
            if (resultHeader != null) {
                message.setHeader(resultHeader, result);
            } else {
                message.setBody(result);
            }
        } else {
            message.setHeader("CamelAtomixResourceActionHasResult", false);
        }
        callback.done(false);
    }

    protected R getResource(Message message) {
        String resourceName = this.getResourceName(message);
        ObjectHelper.notNull(resourceName, "CamelAtomixResourceName");
        return (R)this.resources.computeIfAbsent(resourceName, name -> this.createResource((String)name));
    }

    protected abstract String getResourceName(Message var1);

    protected abstract R createResource(String var1);
}

