/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atomix.client.multimap;

import io.atomix.collections.DistributedMultiMap;
import io.atomix.resource.ReadConsistency;
import io.atomix.resource.Resource;
import java.time.Duration;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Message;
import org.apache.camel.component.atomix.client.AbstractAtomixClientProducer;
import org.apache.camel.component.atomix.client.multimap.AtomixMultiMapConfiguration;
import org.apache.camel.component.atomix.client.multimap.AtomixMultiMapEndpoint;
import org.apache.camel.spi.InvokeOnHeader;
import org.apache.camel.util.ObjectHelper;

public final class AtomixMultiMapProducer
extends AbstractAtomixClientProducer<AtomixMultiMapEndpoint, DistributedMultiMap> {
    private final AtomixMultiMapConfiguration configuration;

    protected AtomixMultiMapProducer(AtomixMultiMapEndpoint endpoint) {
        super(endpoint, endpoint.getConfiguration().getDefaultAction().name());
        this.configuration = endpoint.getConfiguration();
    }

    private long getResourceTtl(Message message) {
        Duration ttl = message.getHeader("CamelAtomixResourceTTL", this.configuration::getTtl, Duration.class);
        return ttl != null ? ttl.toMillis() : 0L;
    }

    @InvokeOnHeader(value="PUT")
    void onPut(Message message, AsyncCallback callback) {
        DistributedMultiMap map = (DistributedMultiMap)this.getResource(message);
        Object key = message.getHeader("CamelAtomixResourceKey", this.configuration::getKey, Object.class);
        Object val = message.getHeader("CamelAtomixResourceValue", message::getBody, Object.class);
        long ttl = this.getResourceTtl(message);
        ObjectHelper.notNull(key, "CamelAtomixResourceKey");
        ObjectHelper.notNull(val, "CamelAtomixResourceValue");
        if (ttl > 0L) {
            map.put(key, val, Duration.ofMillis(ttl)).thenAccept(result -> this.processResult(message, callback, result));
        } else {
            map.put(key, val).thenAccept(result -> this.processResult(message, callback, result));
        }
    }

    @InvokeOnHeader(value="GET")
    void onGet(Message message, AsyncCallback callback) {
        DistributedMultiMap map = (DistributedMultiMap)this.getResource(message);
        Object key = message.getHeader("CamelAtomixResourceKey", this.configuration::getKey, Object.class);
        ReadConsistency consistency = message.getHeader("CamelAtomixResourceReadConsistency", this.configuration::getReadConsistency, ReadConsistency.class);
        ObjectHelper.notNull(key, "CamelAtomixResourceKey");
        if (consistency != null) {
            map.get(key, consistency).thenAccept(result -> this.processResult(message, callback, result));
        } else {
            map.get(key).thenAccept(result -> this.processResult(message, callback, result));
        }
    }

    @InvokeOnHeader(value="CLEAR")
    void onClear(Message message, AsyncCallback callback) {
        DistributedMultiMap map = (DistributedMultiMap)this.getResource(message);
        map.clear().thenAccept(result -> this.processResult(message, callback, result));
    }

    @InvokeOnHeader(value="SIZE")
    void onSize(Message message, AsyncCallback callback) {
        DistributedMultiMap map = (DistributedMultiMap)this.getResource(message);
        ReadConsistency consistency = message.getHeader("CamelAtomixResourceReadConsistency", this.configuration::getReadConsistency, ReadConsistency.class);
        Object key = message.getHeader("CamelAtomixResourceKey", message::getBody, Object.class);
        if (consistency != null) {
            if (key != null) {
                map.size(key, consistency).thenAccept(result -> this.processResult(message, callback, result));
            } else {
                map.size(consistency).thenAccept(result -> this.processResult(message, callback, result));
            }
        } else if (key != null) {
            map.size(key).thenAccept(result -> this.processResult(message, callback, result));
        } else {
            map.size().thenAccept(result -> this.processResult(message, callback, result));
        }
    }

    @InvokeOnHeader(value="IS_EMPTY")
    void onIsEmpty(Message message, AsyncCallback callback) {
        DistributedMultiMap map = (DistributedMultiMap)this.getResource(message);
        ReadConsistency consistency = message.getHeader("CamelAtomixResourceReadConsistency", this.configuration::getReadConsistency, ReadConsistency.class);
        if (consistency != null) {
            map.isEmpty(consistency).thenAccept(result -> this.processResult(message, callback, result));
        } else {
            map.isEmpty().thenAccept(result -> this.processResult(message, callback, result));
        }
    }

    @InvokeOnHeader(value="CONTAINS_KEY")
    void onContainsKey(Message message, AsyncCallback callback) {
        DistributedMultiMap map = (DistributedMultiMap)this.getResource(message);
        ReadConsistency consistency = message.getHeader("CamelAtomixResourceReadConsistency", this.configuration::getReadConsistency, ReadConsistency.class);
        Object key = message.getHeader("CamelAtomixResourceKey", message::getBody, Object.class);
        ObjectHelper.notNull(key, "CamelAtomixResourceKey");
        if (consistency != null) {
            map.containsKey(key, consistency).thenAccept(result -> this.processResult(message, callback, result));
        } else {
            map.containsKey(key).thenAccept(result -> this.processResult(message, callback, result));
        }
    }

    @InvokeOnHeader(value="CONTAINS_VALUE")
    void onContainsValue(Message message, AsyncCallback callback) {
        DistributedMultiMap map = (DistributedMultiMap)this.getResource(message);
        ReadConsistency consistency = message.getHeader("CamelAtomixResourceReadConsistency", this.configuration::getReadConsistency, ReadConsistency.class);
        Object value = message.getHeader("CamelAtomixResourceValue", message::getBody, Object.class);
        ObjectHelper.notNull(value, "CamelAtomixResourceValue");
        if (consistency != null) {
            map.containsValue(value, consistency).thenAccept(result -> this.processResult(message, callback, result));
        } else {
            map.containsValue(value).thenAccept(result -> this.processResult(message, callback, result));
        }
    }

    @InvokeOnHeader(value="CONTAINS_ENTRY")
    void onContainsEntry(Message message, AsyncCallback callback) {
        DistributedMultiMap map = (DistributedMultiMap)this.getResource(message);
        ReadConsistency consistency = message.getHeader("CamelAtomixResourceReadConsistency", this.configuration::getReadConsistency, ReadConsistency.class);
        Object key = message.getHeader("CamelAtomixResourceKey", message::getBody, Object.class);
        Object value = message.getHeader("CamelAtomixResourceValue", message::getBody, Object.class);
        ObjectHelper.notNull(key, "CamelAtomixResourceValue");
        ObjectHelper.notNull(value, "CamelAtomixResourceKey");
        if (consistency != null) {
            map.containsEntry(key, value, consistency).thenAccept(result -> this.processResult(message, callback, result));
        } else {
            map.containsEntry(key, value).thenAccept(result -> this.processResult(message, callback, result));
        }
    }

    @InvokeOnHeader(value="REMOVE")
    void onRemove(Message message, AsyncCallback callback) {
        DistributedMultiMap map = (DistributedMultiMap)this.getResource(message);
        Object key = message.getHeader("CamelAtomixResourceKey", message::getBody, Object.class);
        Object value = message.getHeader("CamelAtomixResourceValue", message::getBody, Object.class);
        ObjectHelper.notNull(key, "CamelAtomixResourceKey");
        if (value != null) {
            map.remove(key, value).thenAccept(result -> this.processResult(message, callback, result));
        } else {
            map.remove(key).thenAccept(result -> this.processResult(message, callback, result));
        }
    }

    @InvokeOnHeader(value="REMOVE_VALUE")
    void onRemoveValue(Message message, AsyncCallback callback) {
        DistributedMultiMap map = (DistributedMultiMap)this.getResource(message);
        Object value = message.getHeader("CamelAtomixResourceValue", message::getBody, Object.class);
        ObjectHelper.notNull(value, "CamelAtomixResourceValue");
        map.removeValue(value).thenAccept(result -> this.processResult(message, callback, result));
    }

    @Override
    protected String getResourceName(Message message) {
        return message.getHeader("CamelAtomixResourceName", ((AtomixMultiMapEndpoint)this.getAtomixEndpoint())::getResourceName, String.class);
    }

    @Override
    protected DistributedMultiMap<Object, Object> createResource(String resourceName) {
        return ((AtomixMultiMapEndpoint)this.getAtomixEndpoint()).getAtomix().getMultiMap(resourceName, new DistributedMultiMap.Config(((AtomixMultiMapEndpoint)this.getAtomixEndpoint()).getConfiguration().getResourceOptions(resourceName)), new Resource.Options(((AtomixMultiMapEndpoint)this.getAtomixEndpoint()).getConfiguration().getResourceConfig(resourceName))).join();
    }
}

