/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atomix.client.queue;

import io.atomix.Atomix;
import io.atomix.catalyst.transport.Address;
import io.atomix.resource.ReadConsistency;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.component.atomix.client.queue.AtomixQueue;
import org.apache.camel.component.atomix.client.queue.AtomixQueueComponent;
import org.apache.camel.component.atomix.client.queue.AtomixQueueConfiguration;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class AtomixQueueComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private AtomixQueueConfiguration getOrCreateConfiguration(AtomixQueueComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new AtomixQueueConfiguration());
        }
        return target.getConfiguration();
    }

    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        AtomixQueueComponent target = (AtomixQueueComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "atomix": {
                this.getOrCreateConfiguration(target).setAtomix(AtomixQueueComponentConfigurer.property(camelContext, Atomix.class, value));
                return true;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                target.setAutowiredEnabled(AtomixQueueComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler(AtomixQueueComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "configuration": {
                target.setConfiguration(AtomixQueueComponentConfigurer.property(camelContext, AtomixQueueConfiguration.class, value));
                return true;
            }
            case "configurationuri": 
            case "configurationUri": {
                target.setConfigurationUri(AtomixQueueComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "defaultaction": 
            case "defaultAction": {
                this.getOrCreateConfiguration(target).setDefaultAction(AtomixQueueComponentConfigurer.property(camelContext, AtomixQueue.Action.class, value));
                return true;
            }
            case "defaultresourceconfig": 
            case "defaultResourceConfig": {
                this.getOrCreateConfiguration(target).setDefaultResourceConfig(AtomixQueueComponentConfigurer.property(camelContext, Properties.class, value));
                return true;
            }
            case "defaultresourceoptions": 
            case "defaultResourceOptions": {
                this.getOrCreateConfiguration(target).setDefaultResourceOptions(AtomixQueueComponentConfigurer.property(camelContext, Properties.class, value));
                return true;
            }
            case "ephemeral": {
                this.getOrCreateConfiguration(target).setEphemeral(AtomixQueueComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(AtomixQueueComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "nodes": {
                target.setNodes(AtomixQueueComponentConfigurer.property(camelContext, List.class, value));
                return true;
            }
            case "readconsistency": 
            case "readConsistency": {
                this.getOrCreateConfiguration(target).setReadConsistency(AtomixQueueComponentConfigurer.property(camelContext, ReadConsistency.class, value));
                return true;
            }
            case "resourceconfigs": 
            case "resourceConfigs": {
                this.getOrCreateConfiguration(target).setResourceConfigs(AtomixQueueComponentConfigurer.property(camelContext, Map.class, value));
                return true;
            }
            case "resourceoptions": 
            case "resourceOptions": {
                this.getOrCreateConfiguration(target).setResourceOptions(AtomixQueueComponentConfigurer.property(camelContext, Map.class, value));
                return true;
            }
            case "resultheader": 
            case "resultHeader": {
                this.getOrCreateConfiguration(target).setResultHeader(AtomixQueueComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "transportclassname": 
            case "transportClassName": {
                this.getOrCreateConfiguration(target).setTransportClassName(AtomixQueueComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "atomix": {
                return Atomix.class;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return Boolean.TYPE;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "configuration": {
                return AtomixQueueConfiguration.class;
            }
            case "configurationuri": 
            case "configurationUri": {
                return String.class;
            }
            case "defaultaction": 
            case "defaultAction": {
                return AtomixQueue.Action.class;
            }
            case "defaultresourceconfig": 
            case "defaultResourceConfig": {
                return Properties.class;
            }
            case "defaultresourceoptions": 
            case "defaultResourceOptions": {
                return Properties.class;
            }
            case "ephemeral": {
                return Boolean.TYPE;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "nodes": {
                return List.class;
            }
            case "readconsistency": 
            case "readConsistency": {
                return ReadConsistency.class;
            }
            case "resourceconfigs": 
            case "resourceConfigs": {
                return Map.class;
            }
            case "resourceoptions": 
            case "resourceOptions": {
                return Map.class;
            }
            case "resultheader": 
            case "resultHeader": {
                return String.class;
            }
            case "transportclassname": 
            case "transportClassName": {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        AtomixQueueComponent target = (AtomixQueueComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "atomix": {
                return this.getOrCreateConfiguration(target).getAtomix();
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return target.isAutowiredEnabled();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "configurationuri": 
            case "configurationUri": {
                return target.getConfigurationUri();
            }
            case "defaultaction": 
            case "defaultAction": {
                return this.getOrCreateConfiguration(target).getDefaultAction();
            }
            case "defaultresourceconfig": 
            case "defaultResourceConfig": {
                return this.getOrCreateConfiguration(target).getDefaultResourceConfig();
            }
            case "defaultresourceoptions": 
            case "defaultResourceOptions": {
                return this.getOrCreateConfiguration(target).getDefaultResourceOptions();
            }
            case "ephemeral": {
                return this.getOrCreateConfiguration(target).isEphemeral();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "nodes": {
                return target.getNodes();
            }
            case "readconsistency": 
            case "readConsistency": {
                return this.getOrCreateConfiguration(target).getReadConsistency();
            }
            case "resourceconfigs": 
            case "resourceConfigs": {
                return this.getOrCreateConfiguration(target).getResourceConfigs();
            }
            case "resourceoptions": 
            case "resourceOptions": {
                return this.getOrCreateConfiguration(target).getResourceOptions();
            }
            case "resultheader": 
            case "resultHeader": {
                return this.getOrCreateConfiguration(target).getResultHeader();
            }
            case "transportclassname": 
            case "transportClassName": {
                return this.getOrCreateConfiguration(target).getTransportClassName();
            }
        }
        return null;
    }

    @Override
    public Object getCollectionValueType(Object target, String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "nodes": {
                return Address.class;
            }
            case "resourceconfigs": 
            case "resourceConfigs": {
                return Properties.class;
            }
            case "resourceoptions": 
            case "resourceOptions": {
                return Properties.class;
            }
        }
        return null;
    }
}

