/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atomix.client.queue;

import io.atomix.catalyst.concurrent.Listener;
import io.atomix.collections.DistributedQueue;
import io.atomix.resource.Resource;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.atomix.client.AbstractAtomixClientConsumer;
import org.apache.camel.component.atomix.client.queue.AtomixQueueEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AtomixQueueConsumer
extends AbstractAtomixClientConsumer<AtomixQueueEndpoint> {
    private static final Logger LOG = LoggerFactory.getLogger(AtomixQueueConsumer.class);
    private final List<Listener<DistributedQueue.ValueEvent<Object>>> listeners = new ArrayList<Listener<DistributedQueue.ValueEvent<Object>>>();
    private final String resourceName;
    private final String resultHeader;
    private DistributedQueue<Object> queue;

    public AtomixQueueConsumer(AtomixQueueEndpoint endpoint, Processor processor, String resourceName) {
        super(endpoint, processor);
        this.resourceName = resourceName;
        this.resultHeader = endpoint.getConfiguration().getResultHeader();
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.queue = ((AtomixQueueEndpoint)this.getAtomixEndpoint()).getAtomix().getQueue(this.resourceName, new Resource.Config(((AtomixQueueEndpoint)this.getAtomixEndpoint()).getConfiguration().getResourceOptions(this.resourceName)), new Resource.Options(((AtomixQueueEndpoint)this.getAtomixEndpoint()).getConfiguration().getResourceConfig(this.resourceName))).join();
        LOG.debug("Subscribe to events for queue: {}", (Object)this.resourceName);
        this.listeners.add(this.queue.onAdd(this::onEvent).join());
        this.listeners.add(this.queue.onRemove(this::onEvent).join());
    }

    @Override
    protected void doStop() throws Exception {
        this.listeners.forEach(Listener::close);
        super.doStop();
    }

    private void onEvent(DistributedQueue.ValueEvent<Object> event) {
        Exchange exchange = this.createExchange(true);
        exchange.getIn().setHeader("CamelAtomixEventType", event.type());
        if (this.resultHeader == null) {
            exchange.getIn().setBody(event.value());
        } else {
            exchange.getIn().setHeader(this.resultHeader, event.value());
        }
        try {
            this.getProcessor().process(exchange);
        }
        catch (Exception e) {
            this.getExceptionHandler().handleException(e);
        }
    }
}

