/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atomix.client.set;

import io.atomix.Atomix;
import io.atomix.resource.ReadConsistency;
import java.time.Duration;
import java.util.Map;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.atomix.client.set.AtomixSet;
import org.apache.camel.component.atomix.client.set.AtomixSetEndpoint;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class AtomixSetEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        AtomixSetEndpoint target = (AtomixSetEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "atomix": {
                target.getConfiguration().setAtomix(AtomixSetEndpointConfigurer.property(camelContext, Atomix.class, value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler(AtomixSetEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "configurationuri": 
            case "configurationUri": {
                target.getConfiguration().setConfigurationUri(AtomixSetEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "defaultaction": 
            case "defaultAction": {
                target.getConfiguration().setDefaultAction(AtomixSetEndpointConfigurer.property(camelContext, AtomixSet.Action.class, value));
                return true;
            }
            case "defaultresourceconfig": 
            case "defaultResourceConfig": {
                target.getConfiguration().setDefaultResourceConfig(AtomixSetEndpointConfigurer.property(camelContext, Properties.class, value));
                return true;
            }
            case "defaultresourceoptions": 
            case "defaultResourceOptions": {
                target.getConfiguration().setDefaultResourceOptions(AtomixSetEndpointConfigurer.property(camelContext, Properties.class, value));
                return true;
            }
            case "ephemeral": {
                target.getConfiguration().setEphemeral(AtomixSetEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                target.setExceptionHandler(AtomixSetEndpointConfigurer.property(camelContext, ExceptionHandler.class, value));
                return true;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                target.setExchangePattern(AtomixSetEndpointConfigurer.property(camelContext, ExchangePattern.class, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(AtomixSetEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "nodes": {
                target.getConfiguration().setNodes(AtomixSetEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "readconsistency": 
            case "readConsistency": {
                target.getConfiguration().setReadConsistency(AtomixSetEndpointConfigurer.property(camelContext, ReadConsistency.class, value));
                return true;
            }
            case "resourceconfigs": 
            case "resourceConfigs": {
                target.getConfiguration().setResourceConfigs(AtomixSetEndpointConfigurer.property(camelContext, Map.class, value));
                return true;
            }
            case "resourceoptions": 
            case "resourceOptions": {
                target.getConfiguration().setResourceOptions(AtomixSetEndpointConfigurer.property(camelContext, Map.class, value));
                return true;
            }
            case "resultheader": 
            case "resultHeader": {
                target.getConfiguration().setResultHeader(AtomixSetEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "transportclassname": 
            case "transportClassName": {
                target.getConfiguration().setTransportClassName(AtomixSetEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "ttl": {
                target.getConfiguration().setTtl(AtomixSetEndpointConfigurer.property(camelContext, Duration.class, value).toMillis());
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "atomix": {
                return Atomix.class;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "configurationuri": 
            case "configurationUri": {
                return String.class;
            }
            case "defaultaction": 
            case "defaultAction": {
                return AtomixSet.Action.class;
            }
            case "defaultresourceconfig": 
            case "defaultResourceConfig": {
                return Properties.class;
            }
            case "defaultresourceoptions": 
            case "defaultResourceOptions": {
                return Properties.class;
            }
            case "ephemeral": {
                return Boolean.TYPE;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return ExceptionHandler.class;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return ExchangePattern.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "nodes": {
                return String.class;
            }
            case "readconsistency": 
            case "readConsistency": {
                return ReadConsistency.class;
            }
            case "resourceconfigs": 
            case "resourceConfigs": {
                return Map.class;
            }
            case "resourceoptions": 
            case "resourceOptions": {
                return Map.class;
            }
            case "resultheader": 
            case "resultHeader": {
                return String.class;
            }
            case "transportclassname": 
            case "transportClassName": {
                return String.class;
            }
            case "ttl": {
                return Long.TYPE;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        AtomixSetEndpoint target = (AtomixSetEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "atomix": {
                return target.getConfiguration().getAtomix();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "configurationuri": 
            case "configurationUri": {
                return target.getConfiguration().getConfigurationUri();
            }
            case "defaultaction": 
            case "defaultAction": {
                return target.getConfiguration().getDefaultAction();
            }
            case "defaultresourceconfig": 
            case "defaultResourceConfig": {
                return target.getConfiguration().getDefaultResourceConfig();
            }
            case "defaultresourceoptions": 
            case "defaultResourceOptions": {
                return target.getConfiguration().getDefaultResourceOptions();
            }
            case "ephemeral": {
                return target.getConfiguration().isEphemeral();
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return target.getExceptionHandler();
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return target.getExchangePattern();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "nodes": {
                return target.getConfiguration().getNodes();
            }
            case "readconsistency": 
            case "readConsistency": {
                return target.getConfiguration().getReadConsistency();
            }
            case "resourceconfigs": 
            case "resourceConfigs": {
                return target.getConfiguration().getResourceConfigs();
            }
            case "resourceoptions": 
            case "resourceOptions": {
                return target.getConfiguration().getResourceOptions();
            }
            case "resultheader": 
            case "resultHeader": {
                return target.getConfiguration().getResultHeader();
            }
            case "transportclassname": 
            case "transportClassName": {
                return target.getConfiguration().getTransportClassName();
            }
            case "ttl": {
                return target.getConfiguration().getTtl();
            }
        }
        return null;
    }

    @Override
    public Object getCollectionValueType(Object target, String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "resourceconfigs": 
            case "resourceConfigs": {
                return Properties.class;
            }
            case "resourceoptions": 
            case "resourceOptions": {
                return Properties.class;
            }
        }
        return null;
    }
}

