/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atomix.client.value;

import io.atomix.Atomix;
import io.atomix.resource.ReadConsistency;
import java.time.Duration;
import java.util.Map;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.atomix.client.value.AtomixValue;
import org.apache.camel.component.atomix.client.value.AtomixValueEndpoint;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class AtomixValueEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        AtomixValueEndpoint target = (AtomixValueEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "atomix": {
                target.getConfiguration().setAtomix(AtomixValueEndpointConfigurer.property(camelContext, Atomix.class, value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler(AtomixValueEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "configurationuri": 
            case "configurationUri": {
                target.getConfiguration().setConfigurationUri(AtomixValueEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "defaultaction": 
            case "defaultAction": {
                target.getConfiguration().setDefaultAction(AtomixValueEndpointConfigurer.property(camelContext, AtomixValue.Action.class, value));
                return true;
            }
            case "defaultresourceconfig": 
            case "defaultResourceConfig": {
                target.getConfiguration().setDefaultResourceConfig(AtomixValueEndpointConfigurer.property(camelContext, Properties.class, value));
                return true;
            }
            case "defaultresourceoptions": 
            case "defaultResourceOptions": {
                target.getConfiguration().setDefaultResourceOptions(AtomixValueEndpointConfigurer.property(camelContext, Properties.class, value));
                return true;
            }
            case "ephemeral": {
                target.getConfiguration().setEphemeral(AtomixValueEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                target.setExceptionHandler(AtomixValueEndpointConfigurer.property(camelContext, ExceptionHandler.class, value));
                return true;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                target.setExchangePattern(AtomixValueEndpointConfigurer.property(camelContext, ExchangePattern.class, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(AtomixValueEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "nodes": {
                target.getConfiguration().setNodes(AtomixValueEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "readconsistency": 
            case "readConsistency": {
                target.getConfiguration().setReadConsistency(AtomixValueEndpointConfigurer.property(camelContext, ReadConsistency.class, value));
                return true;
            }
            case "resourceconfigs": 
            case "resourceConfigs": {
                target.getConfiguration().setResourceConfigs(AtomixValueEndpointConfigurer.property(camelContext, Map.class, value));
                return true;
            }
            case "resourceoptions": 
            case "resourceOptions": {
                target.getConfiguration().setResourceOptions(AtomixValueEndpointConfigurer.property(camelContext, Map.class, value));
                return true;
            }
            case "resultheader": 
            case "resultHeader": {
                target.getConfiguration().setResultHeader(AtomixValueEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "transportclassname": 
            case "transportClassName": {
                target.getConfiguration().setTransportClassName(AtomixValueEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "ttl": {
                target.getConfiguration().setTtl(AtomixValueEndpointConfigurer.property(camelContext, Duration.class, value).toMillis());
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "atomix": {
                return Atomix.class;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "configurationuri": 
            case "configurationUri": {
                return String.class;
            }
            case "defaultaction": 
            case "defaultAction": {
                return AtomixValue.Action.class;
            }
            case "defaultresourceconfig": 
            case "defaultResourceConfig": {
                return Properties.class;
            }
            case "defaultresourceoptions": 
            case "defaultResourceOptions": {
                return Properties.class;
            }
            case "ephemeral": {
                return Boolean.TYPE;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return ExceptionHandler.class;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return ExchangePattern.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "nodes": {
                return String.class;
            }
            case "readconsistency": 
            case "readConsistency": {
                return ReadConsistency.class;
            }
            case "resourceconfigs": 
            case "resourceConfigs": {
                return Map.class;
            }
            case "resourceoptions": 
            case "resourceOptions": {
                return Map.class;
            }
            case "resultheader": 
            case "resultHeader": {
                return String.class;
            }
            case "transportclassname": 
            case "transportClassName": {
                return String.class;
            }
            case "ttl": {
                return Long.TYPE;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        AtomixValueEndpoint target = (AtomixValueEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "atomix": {
                return target.getConfiguration().getAtomix();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "configurationuri": 
            case "configurationUri": {
                return target.getConfiguration().getConfigurationUri();
            }
            case "defaultaction": 
            case "defaultAction": {
                return target.getConfiguration().getDefaultAction();
            }
            case "defaultresourceconfig": 
            case "defaultResourceConfig": {
                return target.getConfiguration().getDefaultResourceConfig();
            }
            case "defaultresourceoptions": 
            case "defaultResourceOptions": {
                return target.getConfiguration().getDefaultResourceOptions();
            }
            case "ephemeral": {
                return target.getConfiguration().isEphemeral();
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return target.getExceptionHandler();
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return target.getExchangePattern();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "nodes": {
                return target.getConfiguration().getNodes();
            }
            case "readconsistency": 
            case "readConsistency": {
                return target.getConfiguration().getReadConsistency();
            }
            case "resourceconfigs": 
            case "resourceConfigs": {
                return target.getConfiguration().getResourceConfigs();
            }
            case "resourceoptions": 
            case "resourceOptions": {
                return target.getConfiguration().getResourceOptions();
            }
            case "resultheader": 
            case "resultHeader": {
                return target.getConfiguration().getResultHeader();
            }
            case "transportclassname": 
            case "transportClassName": {
                return target.getConfiguration().getTransportClassName();
            }
            case "ttl": {
                return target.getConfiguration().getTtl();
            }
        }
        return null;
    }

    @Override
    public Object getCollectionValueType(Object target, String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "resourceconfigs": 
            case "resourceConfigs": {
                return Properties.class;
            }
            case "resourceoptions": 
            case "resourceOptions": {
                return Properties.class;
            }
        }
        return null;
    }
}

