/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atomix.cluster;

import io.atomix.AtomixReplica;
import io.atomix.catalyst.transport.Address;
import io.atomix.catalyst.transport.Transport;
import io.atomix.copycat.server.storage.Storage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.component.atomix.cluster.AtomixClusterConfiguration;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.util.ObjectHelper;

public final class AtomixClusterHelper {
    private AtomixClusterHelper() {
    }

    public static AtomixReplica createReplica(CamelContext camelContext, String address, AtomixClusterConfiguration configuration) throws Exception {
        return AtomixClusterHelper.createReplica(camelContext, new Address(address), configuration);
    }

    public static AtomixReplica createReplica(CamelContext camelContext, Address address, AtomixClusterConfiguration configuration) throws IOException, ClassNotFoundException {
        AtomixReplica atomix = (AtomixReplica)configuration.getAtomix();
        if (atomix == null) {
            AtomixReplica.Builder atomixBuilder;
            String uri = configuration.getConfigurationUri();
            if (ObjectHelper.isNotEmpty(uri)) {
                uri = camelContext.resolvePropertyPlaceholders(uri);
                try (InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream(camelContext, uri);){
                    Properties properties = new Properties();
                    properties.load(is);
                    atomixBuilder = AtomixReplica.builder(address, properties);
                }
            } else {
                atomixBuilder = AtomixReplica.builder(address);
            }
            Storage.Builder storageBuilder = Storage.builder();
            ObjectHelper.ifNotEmpty(configuration.getStorageLevel(), storageBuilder::withStorageLevel);
            ObjectHelper.ifNotEmpty(configuration.getStoragePath(), storageBuilder::withDirectory);
            atomixBuilder.withStorage(storageBuilder.build());
            if (configuration.getTransportClassName() != null) {
                Class<Transport> clazz = camelContext.getClassResolver().resolveMandatoryClass(configuration.getTransportClassName(), Transport.class);
                atomixBuilder.withTransport(camelContext.getInjector().newInstance(clazz));
            }
            if (configuration.getClientTransport() != null) {
                atomixBuilder.withClientTransport(camelContext.getInjector().newInstance(configuration.getClientTransport()));
            }
            if (configuration.getServerTransport() != null) {
                atomixBuilder.withServerTransport(camelContext.getInjector().newInstance(configuration.getServerTransport()));
            }
            atomix = atomixBuilder.build();
        }
        return atomix;
    }
}

