/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atomix.cluster;

import io.atomix.AtomixReplica;
import io.atomix.catalyst.transport.Address;
import io.atomix.copycat.server.storage.StorageLevel;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.component.atomix.cluster.AtomixClusterConfiguration;
import org.apache.camel.component.atomix.cluster.AtomixClusterHelper;
import org.apache.camel.component.atomix.cluster.AtomixClusterView;
import org.apache.camel.support.cluster.AbstractCamelClusterService;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AtomixClusterService
extends AbstractCamelClusterService<AtomixClusterView> {
    private static final Logger LOG = LoggerFactory.getLogger(AtomixClusterService.class);
    private Address address;
    private AtomixClusterConfiguration configuration;
    private AtomixReplica atomix;

    public AtomixClusterService() {
        this.configuration = new AtomixClusterConfiguration();
    }

    public AtomixClusterService(CamelContext camelContext, Address address, AtomixClusterConfiguration configuration) {
        super(null, camelContext);
        this.address = address;
        this.configuration = configuration.copy();
    }

    public Address getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = new Address(address);
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public AtomixClusterConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(AtomixClusterConfiguration configuration) {
        this.configuration = configuration.copy();
    }

    public String getStoragePath() {
        return this.configuration.getStoragePath();
    }

    public void setStoragePath(String storagePath) {
        this.configuration.setStoragePath(storagePath);
    }

    public StorageLevel getStorageLevel() {
        return this.configuration.getStorageLevel();
    }

    public List<Address> getNodes() {
        return this.configuration.getNodes();
    }

    public void setNodes(List<Address> nodes) {
        this.configuration.setNodes(nodes);
    }

    public void setStorageLevel(StorageLevel storageLevel) {
        this.configuration.setStorageLevel(storageLevel);
    }

    public void setNodes(String nodes) {
        this.configuration.setNodes(nodes);
    }

    public String getTransport() {
        return this.configuration.getTransportClassName();
    }

    public void setTransportClassName(String transport) {
        this.configuration.setTransportClassName(transport);
    }

    public AtomixReplica getAtomix() {
        return (AtomixReplica)this.configuration.getAtomix();
    }

    public void setAtomix(AtomixReplica atomix) {
        this.configuration.setAtomix(atomix);
    }

    public String getConfigurationUri() {
        return this.configuration.getConfigurationUri();
    }

    public void setConfigurationUri(String configurationUri) {
        this.configuration.setConfigurationUri(configurationUri);
    }

    public boolean isEphemeral() {
        return this.configuration.isEphemeral();
    }

    public void setEphemeral(boolean ephemeral) {
        this.configuration.setEphemeral(ephemeral);
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        if (this.atomix != null) {
            LOG.debug("Leaving atomix cluster replica {}", (Object)this.atomix);
            this.atomix.leave().join();
        }
    }

    @Override
    protected AtomixClusterView createView(String namespace) throws Exception {
        return new AtomixClusterView(this, namespace, this.getOrCreateReplica(), this.configuration);
    }

    private AtomixReplica getOrCreateReplica() throws Exception {
        if (this.atomix == null) {
            ObjectHelper.notNull(this.getCamelContext(), "Camel Context");
            ObjectHelper.notNull(this.address, "Atomix Node Address");
            ObjectHelper.notNull(this.configuration, "Atomix Node Configuration");
            this.atomix = AtomixClusterHelper.createReplica(this.getCamelContext(), this.address, this.configuration);
            if (ObjectHelper.isNotEmpty(this.configuration.getNodes())) {
                LOG.debug("Bootstrap cluster on address {} for nodes: {}", (Object)this.address, this.configuration.getNodes());
                this.atomix.bootstrap(this.configuration.getNodes()).join();
                LOG.debug("Bootstrap cluster done");
            } else {
                LOG.debug("Bootstrap cluster on address {}", (Object)this.address);
                this.atomix.bootstrap().join();
                LOG.debug("Bootstrap cluster done");
            }
        }
        return this.atomix;
    }
}

