/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.avro;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericContainer;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.CamelException;
import org.apache.camel.Exchange;
import org.apache.camel.dataformat.avro.SpecificDataNoCache;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.ObjectHelper;

public class AvroDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName,
CamelContextAware {
    private static final String GENERIC_CONTAINER_CLASSNAME = GenericContainer.class.getName();
    private CamelContext camelContext;
    private Object schema;
    private transient Schema actualSchema;
    private String instanceClassName;

    public AvroDataFormat() {
    }

    public AvroDataFormat(Schema schema) {
        this.schema = schema;
    }

    public String getDataFormatName() {
        return "avro";
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    protected void doStart() throws Exception {
        if (this.schema != null) {
            this.actualSchema = this.schema instanceof Schema ? (Schema)this.schema : this.loadSchema(this.schema.getClass().getName());
        } else if (this.instanceClassName != null) {
            this.actualSchema = this.loadSchema(this.instanceClassName);
        }
    }

    protected void doStop() throws Exception {
    }

    public Object getSchema() {
        return this.actualSchema != null ? this.actualSchema : this.schema;
    }

    public void setSchema(Object schema) {
        this.schema = schema;
    }

    public String getInstanceClassName() {
        return this.instanceClassName;
    }

    public void setInstanceClassName(String className) throws Exception {
        this.instanceClassName = className;
    }

    protected Schema loadSchema(String className) throws CamelException, ClassNotFoundException {
        Class instanceClass = this.camelContext.getClassResolver().resolveMandatoryClass(className);
        Class genericContainer = this.camelContext.getClassResolver().resolveMandatoryClass(GENERIC_CONTAINER_CLASSNAME);
        if (genericContainer.isAssignableFrom(instanceClass)) {
            try {
                Method method = instanceClass.getMethod("getSchema", new Class[0]);
                return (Schema)method.invoke(this.camelContext.getInjector().newInstance(instanceClass), new Object[0]);
            }
            catch (Exception ex) {
                throw new CamelException("Error calling getSchema on " + instanceClass, (Throwable)ex);
            }
        }
        throw new CamelException("Class " + instanceClass + " must be instanceof " + GENERIC_CONTAINER_CLASSNAME);
    }

    public void marshal(Exchange exchange, Object graph, OutputStream outputStream) throws Exception {
        Schema useSchema = this.actualSchema != null ? this.actualSchema : this.loadSchema(graph.getClass().getName());
        SpecificDatumWriter datum = new SpecificDatumWriter(useSchema);
        BinaryEncoder encoder = EncoderFactory.get().binaryEncoder(outputStream, null);
        datum.write(graph, encoder);
        encoder.flush();
    }

    public Object unmarshal(Exchange exchange, InputStream inputStream) throws Exception {
        ObjectHelper.notNull((Object)this.actualSchema, (String)"schema", (Object)((Object)this));
        ClassLoader classLoader = null;
        Class clazz = this.camelContext.getClassResolver().resolveClass(this.actualSchema.getFullName());
        if (clazz != null) {
            classLoader = clazz.getClassLoader();
        }
        SpecificDataNoCache specificData = new SpecificDataNoCache(classLoader);
        SpecificDatumReader reader = new SpecificDatumReader(null, null, specificData);
        reader.setSchema(this.actualSchema);
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(inputStream, null);
        Object result = reader.read(null, decoder);
        return result;
    }
}

