/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.avro;

import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.avro.AvroConfiguration;
import org.apache.camel.component.avro.AvroConsumer;
import org.apache.camel.component.avro.AvroEndpoint;
import org.apache.camel.component.avro.AvroHttpEndpoint;
import org.apache.camel.component.avro.AvroListener;
import org.apache.camel.component.avro.AvroNettyEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.URISupport;

@Component(value="avro")
public class AvroComponent
extends DefaultComponent {
    private ConcurrentMap<String, AvroListener> listenerRegistry = new ConcurrentHashMap<String, AvroListener>();
    @Metadata(label="advanced")
    private AvroConfiguration configuration;

    public AvroComponent() {
    }

    public AvroComponent(CamelContext context) {
        super(context);
    }

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        AvroEndpoint answer;
        AvroConfiguration config = this.configuration != null ? this.configuration.copy() : new AvroConfiguration();
        URI endpointUri = new URI(URISupport.normalizeUri(remaining));
        config.parseURI(endpointUri);
        if ("netty".equals(endpointUri.getScheme())) {
            answer = new AvroNettyEndpoint(remaining, this, config);
        } else if ("http".equals(endpointUri.getScheme())) {
            answer = new AvroHttpEndpoint(remaining, this, config);
        } else {
            throw new IllegalArgumentException("Unknown avro scheme. Should use either netty or http.");
        }
        this.setProperties(answer, parameters);
        return answer;
    }

    public void register(String uri, String messageName, AvroConsumer consumer) throws Exception {
        AvroListener listener = (AvroListener)this.listenerRegistry.get(uri);
        if (listener == null) {
            listener = new AvroListener(consumer.getEndpoint());
            this.listenerRegistry.put(uri, listener);
        }
        listener.register(messageName, consumer);
    }

    public void unregister(String uri, String messageName) {
        if (((AvroListener)this.listenerRegistry.get(uri)).unregister(messageName)) {
            this.listenerRegistry.remove(uri);
        }
    }

    public AvroConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(AvroConfiguration configuration) {
        this.configuration = configuration;
    }
}

