/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.avro;

import org.apache.avro.Protocol;
import org.apache.camel.CamelContext;
import org.apache.camel.component.avro.AvroComponent;
import org.apache.camel.component.avro.AvroConfiguration;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class AvroComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private AvroConfiguration getOrCreateConfiguration(AvroComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new AvroConfiguration());
        }
        return target.getConfiguration();
    }

    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        AvroComponent target = (AvroComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                target.setAutowiredEnabled(AvroComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler(AvroComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "configuration": {
                target.setConfiguration(AvroComponentConfigurer.property(camelContext, AvroConfiguration.class, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(AvroComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "protocol": {
                this.getOrCreateConfiguration(target).setProtocol(AvroComponentConfigurer.property(camelContext, Protocol.class, value));
                return true;
            }
            case "protocolclassname": 
            case "protocolClassName": {
                this.getOrCreateConfiguration(target).setProtocolClassName(AvroComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "protocollocation": 
            case "protocolLocation": {
                this.getOrCreateConfiguration(target).setProtocolLocation(AvroComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "reflectionprotocol": 
            case "reflectionProtocol": {
                this.getOrCreateConfiguration(target).setReflectionProtocol(AvroComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "singleparameter": 
            case "singleParameter": {
                this.getOrCreateConfiguration(target).setSingleParameter(AvroComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "uriauthority": 
            case "uriAuthority": {
                this.getOrCreateConfiguration(target).setUriAuthority(AvroComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return Boolean.TYPE;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "configuration": {
                return AvroConfiguration.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "protocol": {
                return Protocol.class;
            }
            case "protocolclassname": 
            case "protocolClassName": {
                return String.class;
            }
            case "protocollocation": 
            case "protocolLocation": {
                return String.class;
            }
            case "reflectionprotocol": 
            case "reflectionProtocol": {
                return Boolean.TYPE;
            }
            case "singleparameter": 
            case "singleParameter": {
                return Boolean.TYPE;
            }
            case "uriauthority": 
            case "uriAuthority": {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        AvroComponent target = (AvroComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return target.isAutowiredEnabled();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "protocol": {
                return this.getOrCreateConfiguration(target).getProtocol();
            }
            case "protocolclassname": 
            case "protocolClassName": {
                return this.getOrCreateConfiguration(target).getProtocolClassName();
            }
            case "protocollocation": 
            case "protocolLocation": {
                return this.getOrCreateConfiguration(target).getProtocolLocation();
            }
            case "reflectionprotocol": 
            case "reflectionProtocol": {
                return this.getOrCreateConfiguration(target).isReflectionProtocol();
            }
            case "singleparameter": 
            case "singleParameter": {
                return this.getOrCreateConfiguration(target).isSingleParameter();
            }
            case "uriauthority": 
            case "uriAuthority": {
                return this.getOrCreateConfiguration(target).getUriAuthority();
            }
        }
        return null;
    }
}

