/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.sqs;

import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSClient;
import com.amazonaws.services.sqs.model.CreateQueueRequest;
import com.amazonaws.services.sqs.model.CreateQueueResult;
import com.amazonaws.services.sqs.model.GetQueueUrlRequest;
import com.amazonaws.services.sqs.model.GetQueueUrlResult;
import com.amazonaws.services.sqs.model.ListQueuesResult;
import com.amazonaws.services.sqs.model.QueueAttributeName;
import com.amazonaws.services.sqs.model.SetQueueAttributesRequest;
import java.util.HashMap;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws.sqs.SqsComponent;
import org.apache.camel.component.aws.sqs.SqsConfiguration;
import org.apache.camel.component.aws.sqs.SqsConsumer;
import org.apache.camel.component.aws.sqs.SqsProducer;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.ScheduledPollEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqsEndpoint
extends ScheduledPollEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(SqsEndpoint.class);
    private AmazonSQS client;
    private String queueUrl;
    private SqsConfiguration configuration;
    private int maxMessagesPerPoll;

    public SqsEndpoint(String uri, SqsComponent component, SqsConfiguration configuration) {
        super(uri, (Component)component);
        this.configuration = configuration;
    }

    public Producer createProducer() throws Exception {
        return new SqsProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        SqsConsumer sqsConsumer = new SqsConsumer(this, processor);
        this.configureConsumer((Consumer)sqsConsumer);
        sqsConsumer.setMaxMessagesPerPoll(this.maxMessagesPerPoll);
        return sqsConsumer;
    }

    public boolean isSingleton() {
        return true;
    }

    protected void doStart() throws Exception {
        AmazonSQS amazonSQS = this.client = this.getConfiguration().getAmazonSQSClient() != null ? this.getConfiguration().getAmazonSQSClient() : this.getClient();
        if (this.configuration.getQueueOwnerAWSAccountId() != null) {
            GetQueueUrlRequest getQueueUrlRequest = new GetQueueUrlRequest();
            getQueueUrlRequest.setQueueName(this.configuration.getQueueName());
            getQueueUrlRequest.setQueueOwnerAWSAccountId(this.configuration.getQueueOwnerAWSAccountId());
            GetQueueUrlResult getQueueUrlResult = this.client.getQueueUrl(getQueueUrlRequest);
            this.queueUrl = getQueueUrlResult.getQueueUrl();
        } else {
            ListQueuesResult listQueuesResult = this.client.listQueues();
            for (String url : listQueuesResult.getQueueUrls()) {
                if (!url.endsWith("/" + this.configuration.getQueueName())) continue;
                this.queueUrl = url;
                LOG.trace("Queue available at '{}'.", (Object)this.queueUrl);
                break;
            }
        }
        if (this.queueUrl == null) {
            this.createQueue(this.client);
        } else {
            this.updateQueueAttributes(this.client);
        }
    }

    private void createQueue(AmazonSQS client) {
        LOG.trace("Queue '{}' doesn't exist. Will create it...", (Object)this.configuration.getQueueName());
        CreateQueueRequest request = new CreateQueueRequest(this.configuration.getQueueName());
        if (this.getConfiguration().getDefaultVisibilityTimeout() != null) {
            request.getAttributes().put(QueueAttributeName.VisibilityTimeout.name(), String.valueOf(this.getConfiguration().getDefaultVisibilityTimeout()));
        }
        if (this.getConfiguration().getMaximumMessageSize() != null) {
            request.getAttributes().put(QueueAttributeName.MaximumMessageSize.name(), String.valueOf(this.getConfiguration().getMaximumMessageSize()));
        }
        if (this.getConfiguration().getMessageRetentionPeriod() != null) {
            request.getAttributes().put(QueueAttributeName.MessageRetentionPeriod.name(), String.valueOf(this.getConfiguration().getMessageRetentionPeriod()));
        }
        if (this.getConfiguration().getPolicy() != null) {
            request.getAttributes().put(QueueAttributeName.Policy.name(), String.valueOf(this.getConfiguration().getPolicy()));
        }
        if (this.getConfiguration().getReceiveMessageWaitTimeSeconds() != null) {
            request.getAttributes().put(QueueAttributeName.ReceiveMessageWaitTimeSeconds.name(), String.valueOf(this.getConfiguration().getReceiveMessageWaitTimeSeconds()));
        }
        LOG.trace("Creating queue [{}] with request [{}]...", (Object)this.configuration.getQueueName(), (Object)request);
        CreateQueueResult queueResult = client.createQueue(request);
        this.queueUrl = queueResult.getQueueUrl();
        LOG.trace("Queue created and available at: {}", (Object)this.queueUrl);
    }

    private void updateQueueAttributes(AmazonSQS client) {
        SetQueueAttributesRequest request = new SetQueueAttributesRequest();
        request.setQueueUrl(this.queueUrl);
        if (this.getConfiguration().getDefaultVisibilityTimeout() != null) {
            request.getAttributes().put(QueueAttributeName.VisibilityTimeout.name(), String.valueOf(this.getConfiguration().getDefaultVisibilityTimeout()));
        }
        if (this.getConfiguration().getMaximumMessageSize() != null) {
            request.getAttributes().put(QueueAttributeName.MaximumMessageSize.name(), String.valueOf(this.getConfiguration().getMaximumMessageSize()));
        }
        if (this.getConfiguration().getMessageRetentionPeriod() != null) {
            request.getAttributes().put(QueueAttributeName.MessageRetentionPeriod.name(), String.valueOf(this.getConfiguration().getMessageRetentionPeriod()));
        }
        if (this.getConfiguration().getPolicy() != null) {
            request.getAttributes().put(QueueAttributeName.Policy.name(), String.valueOf(this.getConfiguration().getPolicy()));
        }
        if (this.getConfiguration().getReceiveMessageWaitTimeSeconds() != null) {
            request.getAttributes().put(QueueAttributeName.ReceiveMessageWaitTimeSeconds.name(), String.valueOf(this.getConfiguration().getReceiveMessageWaitTimeSeconds()));
        }
        if (!request.getAttributes().isEmpty()) {
            LOG.trace("Updating queue '{}' with the provided queue attributes...", (Object)this.configuration.getQueueName());
            client.setQueueAttributes(request);
            LOG.trace("Queue '{}' updated and available at {}'", (Object)this.configuration.getQueueName(), (Object)this.queueUrl);
        }
    }

    protected void doStop() throws Exception {
        this.client = null;
    }

    public Exchange createExchange(com.amazonaws.services.sqs.model.Message msg) {
        return this.createExchange(this.getExchangePattern(), msg);
    }

    private Exchange createExchange(ExchangePattern pattern, com.amazonaws.services.sqs.model.Message msg) {
        DefaultExchange exchange = new DefaultExchange((Endpoint)this, pattern);
        Message message = exchange.getIn();
        message.setBody((Object)msg.getBody());
        message.setHeaders(new HashMap<String, String>(msg.getAttributes()));
        message.setHeader("CamelAwsSqsMessageId", (Object)msg.getMessageId());
        message.setHeader("CamelAwsSqsMD5OfBody", (Object)msg.getMD5OfBody());
        message.setHeader("CamelAwsSqsReceiptHandle", (Object)msg.getReceiptHandle());
        message.setHeader("CamelAwsSqsAttributes", msg.getAttributes());
        return exchange;
    }

    public SqsConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(SqsConfiguration configuration) {
        this.configuration = configuration;
    }

    public AmazonSQS getClient() {
        if (this.client == null) {
            this.client = this.createClient();
        }
        return this.client;
    }

    public void setClient(AmazonSQS client) {
        this.client = client;
    }

    AmazonSQS createClient() {
        BasicAWSCredentials credentials = new BasicAWSCredentials(this.configuration.getAccessKey(), this.configuration.getSecretKey());
        AmazonSQSClient client = new AmazonSQSClient(credentials);
        if (this.configuration.getAmazonSQSEndpoint() != null) {
            client.setEndpoint(this.configuration.getAmazonSQSEndpoint());
        }
        return client;
    }

    protected String getQueueUrl() {
        return this.queueUrl;
    }

    public int getMaxMessagesPerPoll() {
        return this.maxMessagesPerPoll;
    }

    public void setMaxMessagesPerPoll(int maxMessagesPerPoll) {
        this.maxMessagesPerPoll = maxMessagesPerPoll;
    }
}

