/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.waiters;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.jmespath.JmesPathEvaluationVisitor;
import com.amazonaws.jmespath.JmesPathExpression;
import com.amazonaws.jmespath.JmesPathField;
import com.amazonaws.jmespath.JmesPathFlatten;
import com.amazonaws.jmespath.JmesPathProjection;
import com.amazonaws.jmespath.ObjectMapperSingleton;
import com.amazonaws.services.cloudformation.model.DescribeStacksResult;
import com.amazonaws.waiters.AcceptorPathMatcher;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterState;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;

@SdkInternalApi
class StackCreateComplete {
    StackCreateComplete() {
    }

    static class IsValidationErrorMatcher
    extends WaiterAcceptor<DescribeStacksResult> {
        IsValidationErrorMatcher() {
        }

        @Override
        public boolean matches(AmazonServiceException e) {
            return "ValidationError".equals(e.getErrorCode());
        }

        @Override
        public WaiterState getState() {
            return WaiterState.FAILURE;
        }
    }

    static class IsROLLBACK_COMPLETEMatcher
    extends WaiterAcceptor<DescribeStacksResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsROLLBACK_COMPLETEMatcher() {
        }

        @Override
        public boolean matches(DescribeStacksResult result) {
            Object queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree(result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.pathAny(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"ROLLBACK_COMPLETE\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathProjection(new JmesPathFlatten(new JmesPathField("Stacks")), new JmesPathField("StackStatus"));
        }
    }

    static class IsROLLBACK_FAILEDMatcher
    extends WaiterAcceptor<DescribeStacksResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsROLLBACK_FAILEDMatcher() {
        }

        @Override
        public boolean matches(DescribeStacksResult result) {
            Object queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree(result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.pathAny(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"ROLLBACK_FAILED\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathProjection(new JmesPathFlatten(new JmesPathField("Stacks")), new JmesPathField("StackStatus"));
        }
    }

    static class IsDELETE_FAILEDMatcher
    extends WaiterAcceptor<DescribeStacksResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsDELETE_FAILEDMatcher() {
        }

        @Override
        public boolean matches(DescribeStacksResult result) {
            Object queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree(result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.pathAny(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"DELETE_FAILED\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathProjection(new JmesPathFlatten(new JmesPathField("Stacks")), new JmesPathField("StackStatus"));
        }
    }

    static class IsDELETE_COMPLETEMatcher
    extends WaiterAcceptor<DescribeStacksResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsDELETE_COMPLETEMatcher() {
        }

        @Override
        public boolean matches(DescribeStacksResult result) {
            Object queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree(result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.pathAny(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"DELETE_COMPLETE\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathProjection(new JmesPathFlatten(new JmesPathField("Stacks")), new JmesPathField("StackStatus"));
        }
    }

    static class IsCREATE_FAILEDMatcher
    extends WaiterAcceptor<DescribeStacksResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsCREATE_FAILEDMatcher() {
        }

        @Override
        public boolean matches(DescribeStacksResult result) {
            Object queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree(result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.pathAny(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"CREATE_FAILED\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathProjection(new JmesPathFlatten(new JmesPathField("Stacks")), new JmesPathField("StackStatus"));
        }
    }

    static class IsCREATE_COMPLETEMatcher
    extends WaiterAcceptor<DescribeStacksResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsCREATE_COMPLETEMatcher() {
        }

        @Override
        public boolean matches(DescribeStacksResult result) {
            Object queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree(result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.pathAll(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.SUCCESS;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"CREATE_COMPLETE\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathProjection(new JmesPathFlatten(new JmesPathField("Stacks")), new JmesPathField("StackStatus"));
        }
    }
}

