/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.transform.AttachVolumeRequestMarshaller;
import java.io.Serializable;

public class AttachVolumeRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<AttachVolumeRequest> {
    private String volumeId;
    private String instanceId;
    private String device;

    public AttachVolumeRequest() {
    }

    public AttachVolumeRequest(String volumeId, String instanceId, String device) {
        this.setVolumeId(volumeId);
        this.setInstanceId(instanceId);
        this.setDevice(device);
    }

    public void setVolumeId(String volumeId) {
        this.volumeId = volumeId;
    }

    public String getVolumeId() {
        return this.volumeId;
    }

    public AttachVolumeRequest withVolumeId(String volumeId) {
        this.setVolumeId(volumeId);
        return this;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public AttachVolumeRequest withInstanceId(String instanceId) {
        this.setInstanceId(instanceId);
        return this;
    }

    public void setDevice(String device) {
        this.device = device;
    }

    public String getDevice() {
        return this.device;
    }

    public AttachVolumeRequest withDevice(String device) {
        this.setDevice(device);
        return this;
    }

    @Override
    public Request<AttachVolumeRequest> getDryRunRequest() {
        Request<AttachVolumeRequest> request = new AttachVolumeRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVolumeId() != null) {
            sb.append("VolumeId: ").append(this.getVolumeId()).append(",");
        }
        if (this.getInstanceId() != null) {
            sb.append("InstanceId: ").append(this.getInstanceId()).append(",");
        }
        if (this.getDevice() != null) {
            sb.append("Device: ").append(this.getDevice());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachVolumeRequest)) {
            return false;
        }
        AttachVolumeRequest other = (AttachVolumeRequest)obj;
        if (other.getVolumeId() == null ^ this.getVolumeId() == null) {
            return false;
        }
        if (other.getVolumeId() != null && !other.getVolumeId().equals(this.getVolumeId())) {
            return false;
        }
        if (other.getInstanceId() == null ^ this.getInstanceId() == null) {
            return false;
        }
        if (other.getInstanceId() != null && !other.getInstanceId().equals(this.getInstanceId())) {
            return false;
        }
        if (other.getDevice() == null ^ this.getDevice() == null) {
            return false;
        }
        return other.getDevice() == null || other.getDevice().equals(this.getDevice());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVolumeId() == null ? 0 : this.getVolumeId().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceId() == null ? 0 : this.getInstanceId().hashCode());
        hashCode = 31 * hashCode + (this.getDevice() == null ? 0 : this.getDevice().hashCode());
        return hashCode;
    }

    @Override
    public AttachVolumeRequest clone() {
        return (AttachVolumeRequest)super.clone();
    }
}

