/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.jmespath.JmesPathEvaluationVisitor;
import com.amazonaws.jmespath.JmesPathExpression;
import com.amazonaws.jmespath.JmesPathField;
import com.amazonaws.jmespath.JmesPathFlatten;
import com.amazonaws.jmespath.JmesPathProjection;
import com.amazonaws.jmespath.ObjectMapperSingleton;
import com.amazonaws.services.ec2.model.DescribeConversionTasksResult;
import com.amazonaws.waiters.AcceptorPathMatcher;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterState;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;

@SdkInternalApi
class ConversionTaskCompleted {
    ConversionTaskCompleted() {
    }

    static class IsCancellingMatcher
    extends WaiterAcceptor<DescribeConversionTasksResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsCancellingMatcher() {
        }

        @Override
        public boolean matches(DescribeConversionTasksResult result) {
            Object queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree(result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.pathAny(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"cancelling\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathProjection(new JmesPathFlatten(new JmesPathField("ConversionTasks")), new JmesPathField("State"));
        }
    }

    static class IsCancelledMatcher
    extends WaiterAcceptor<DescribeConversionTasksResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsCancelledMatcher() {
        }

        @Override
        public boolean matches(DescribeConversionTasksResult result) {
            Object queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree(result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.pathAny(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"cancelled\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathProjection(new JmesPathFlatten(new JmesPathField("ConversionTasks")), new JmesPathField("State"));
        }
    }

    static class IsCompletedMatcher
    extends WaiterAcceptor<DescribeConversionTasksResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsCompletedMatcher() {
        }

        @Override
        public boolean matches(DescribeConversionTasksResult result) {
            Object queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree(result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.pathAll(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.SUCCESS;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"completed\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathProjection(new JmesPathFlatten(new JmesPathField("ConversionTasks")), new JmesPathField("State"));
        }
    }
}

