/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.jmespath.JmesPathEvaluationVisitor;
import com.amazonaws.jmespath.JmesPathExpression;
import com.amazonaws.jmespath.JmesPathField;
import com.amazonaws.jmespath.JmesPathFlatten;
import com.amazonaws.jmespath.JmesPathProjection;
import com.amazonaws.jmespath.ObjectMapperSingleton;
import com.amazonaws.services.ecs.model.DescribeServicesResult;
import com.amazonaws.waiters.AcceptorPathMatcher;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterState;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;

@SdkInternalApi
class ServicesInactive {
    ServicesInactive() {
    }

    static class IsINACTIVEMatcher
    extends WaiterAcceptor<DescribeServicesResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsINACTIVEMatcher() {
        }

        @Override
        public boolean matches(DescribeServicesResult result) {
            Object queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree(result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.pathAny(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.SUCCESS;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"INACTIVE\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathProjection(new JmesPathFlatten(new JmesPathField("services")), new JmesPathField("status"));
        }
    }

    static class IsMISSINGMatcher
    extends WaiterAcceptor<DescribeServicesResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsMISSINGMatcher() {
        }

        @Override
        public boolean matches(DescribeServicesResult result) {
            Object queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree(result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.pathAny(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"MISSING\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathProjection(new JmesPathFlatten(new JmesPathField("failures")), new JmesPathField("reason"));
        }
    }
}

