/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.waiters;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.jmespath.JmesPathEvaluationVisitor;
import com.amazonaws.jmespath.JmesPathExpression;
import com.amazonaws.jmespath.JmesPathField;
import com.amazonaws.jmespath.JmesPathFlatten;
import com.amazonaws.jmespath.JmesPathProjection;
import com.amazonaws.jmespath.ObjectMapperSingleton;
import com.amazonaws.services.elasticache.model.DescribeReplicationGroupsResult;
import com.amazonaws.waiters.AcceptorPathMatcher;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterState;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;

@SdkInternalApi
class ReplicationGroupDeleted {
    ReplicationGroupDeleted() {
    }

    static class IsReplicationGroupNotFoundFaultMatcher
    extends WaiterAcceptor<DescribeReplicationGroupsResult> {
        IsReplicationGroupNotFoundFaultMatcher() {
        }

        @Override
        public boolean matches(AmazonServiceException e) {
            return "ReplicationGroupNotFoundFault".equals(e.getErrorCode());
        }

        @Override
        public WaiterState getState() {
            return WaiterState.SUCCESS;
        }
    }

    static class IsAvailableMatcher
    extends WaiterAcceptor<DescribeReplicationGroupsResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsAvailableMatcher() {
        }

        @Override
        public boolean matches(DescribeReplicationGroupsResult result) {
            Object queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree(result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.pathAny(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"available\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathProjection(new JmesPathFlatten(new JmesPathField("ReplicationGroups")), new JmesPathField("Status"));
        }
    }

    static class IsDeletedMatcher
    extends WaiterAcceptor<DescribeReplicationGroupsResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsDeletedMatcher() {
        }

        @Override
        public boolean matches(DescribeReplicationGroupsResult result) {
            Object queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree(result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.pathAll(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.SUCCESS;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"deleted\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathProjection(new JmesPathFlatten(new JmesPathField("ReplicationGroups")), new JmesPathField("Status"));
        }
    }
}

