/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.machinelearning.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.jmespath.JmesPathEvaluationVisitor;
import com.amazonaws.jmespath.JmesPathExpression;
import com.amazonaws.jmespath.JmesPathField;
import com.amazonaws.jmespath.JmesPathFlatten;
import com.amazonaws.jmespath.JmesPathProjection;
import com.amazonaws.jmespath.ObjectMapperSingleton;
import com.amazonaws.services.machinelearning.model.DescribeMLModelsResult;
import com.amazonaws.waiters.AcceptorPathMatcher;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterState;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;

@SdkInternalApi
class MLModelAvailable {
    MLModelAvailable() {
    }

    static class IsFAILEDMatcher
    extends WaiterAcceptor<DescribeMLModelsResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsFAILEDMatcher() {
        }

        @Override
        public boolean matches(DescribeMLModelsResult result) {
            Object queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree(result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.pathAny(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"FAILED\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathProjection(new JmesPathFlatten(new JmesPathField("Results")), new JmesPathField("Status"));
        }
    }

    static class IsCOMPLETEDMatcher
    extends WaiterAcceptor<DescribeMLModelsResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsCOMPLETEDMatcher() {
        }

        @Override
        public boolean matches(DescribeMLModelsResult result) {
            Object queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree(result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.pathAll(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.SUCCESS;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"COMPLETED\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathProjection(new JmesPathFlatten(new JmesPathField("Results")), new JmesPathField("Status"));
        }
    }
}

