/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.waiters;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.jmespath.JmesPathEvaluationVisitor;
import com.amazonaws.jmespath.JmesPathExpression;
import com.amazonaws.jmespath.JmesPathField;
import com.amazonaws.jmespath.JmesPathFlatten;
import com.amazonaws.jmespath.JmesPathProjection;
import com.amazonaws.jmespath.ObjectMapperSingleton;
import com.amazonaws.services.rds.model.DescribeDBInstancesResult;
import com.amazonaws.waiters.AcceptorPathMatcher;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterState;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;

@SdkInternalApi
class DBInstanceDeleted {
    DBInstanceDeleted() {
    }

    static class IsResettingmastercredentialsMatcher
    extends WaiterAcceptor<DescribeDBInstancesResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsResettingmastercredentialsMatcher() {
        }

        @Override
        public boolean matches(DescribeDBInstancesResult result) {
            Object queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree(result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.pathAny(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"resetting-master-credentials\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathProjection(new JmesPathFlatten(new JmesPathField("DBInstances")), new JmesPathField("DBInstanceStatus"));
        }
    }

    static class IsRebootingMatcher
    extends WaiterAcceptor<DescribeDBInstancesResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsRebootingMatcher() {
        }

        @Override
        public boolean matches(DescribeDBInstancesResult result) {
            Object queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree(result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.pathAny(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"rebooting\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathProjection(new JmesPathFlatten(new JmesPathField("DBInstances")), new JmesPathField("DBInstanceStatus"));
        }
    }

    static class IsModifyingMatcher
    extends WaiterAcceptor<DescribeDBInstancesResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsModifyingMatcher() {
        }

        @Override
        public boolean matches(DescribeDBInstancesResult result) {
            Object queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree(result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.pathAny(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"modifying\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathProjection(new JmesPathFlatten(new JmesPathField("DBInstances")), new JmesPathField("DBInstanceStatus"));
        }
    }

    static class IsCreatingMatcher
    extends WaiterAcceptor<DescribeDBInstancesResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsCreatingMatcher() {
        }

        @Override
        public boolean matches(DescribeDBInstancesResult result) {
            Object queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree(result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.pathAny(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"creating\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathProjection(new JmesPathFlatten(new JmesPathField("DBInstances")), new JmesPathField("DBInstanceStatus"));
        }
    }

    static class IsDBInstanceNotFoundMatcher
    extends WaiterAcceptor<DescribeDBInstancesResult> {
        IsDBInstanceNotFoundMatcher() {
        }

        @Override
        public boolean matches(AmazonServiceException e) {
            return "DBInstanceNotFound".equals(e.getErrorCode());
        }

        @Override
        public WaiterState getState() {
            return WaiterState.SUCCESS;
        }
    }

    static class IsDeletedMatcher
    extends WaiterAcceptor<DescribeDBInstancesResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsDeletedMatcher() {
        }

        @Override
        public boolean matches(DescribeDBInstancesResult result) {
            Object queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree(result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.pathAll(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.SUCCESS;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"deleted\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathProjection(new JmesPathFlatten(new JmesPathField("DBInstances")), new JmesPathField("DBInstanceStatus"));
        }
    }
}

