/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.stepfunctions.builder.internal;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class DateModule {
    private static final DateTimeFormatter FORMATTER = ISODateTimeFormat.dateTime();
    public static final SimpleModule INSTANCE = new SimpleModule();

    public static Date fromJson(String jsonText) {
        return FORMATTER.parseDateTime(jsonText).toDate();
    }

    static {
        INSTANCE.addSerializer(Date.class, new StdSerializer<Date>(Date.class){

            @Override
            public void serialize(Date date, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
                jsonGenerator.writeString(FORMATTER.print(new DateTime((Object)date, DateTimeZone.UTC)));
            }
        });
        INSTANCE.addDeserializer(Date.class, new StdDeserializer<Date>(Date.class){

            @Override
            public Date deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
                return DateModule.fromJson(jsonParser.getValueAsString());
            }
        });
    }
}

