/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.stepfunctions.builder.states;

import com.amazonaws.services.stepfunctions.builder.conditions.Condition;
import com.amazonaws.services.stepfunctions.builder.conditions.ConditionDeserializer;
import com.amazonaws.services.stepfunctions.builder.internal.Buildable;
import com.amazonaws.services.stepfunctions.builder.states.NextStateTransition;
import com.amazonaws.services.stepfunctions.builder.states.Transition;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;

public final class Choice {
    @JsonUnwrapped
    private final Condition condition;
    @JsonUnwrapped
    private final Transition transition;

    private Choice(Builder builder) {
        this.condition = (Condition)builder.condition.build();
        this.transition = (Transition)builder.transition.build();
    }

    public Condition getCondition() {
        return this.condition;
    }

    public Transition getTransition() {
        return this.transition;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static class ChoiceDeserializer
    extends StdDeserializer<Builder> {
        private final ConditionDeserializer conditionDeserializer = new ConditionDeserializer();

        protected ChoiceDeserializer() {
            super(Choice.class);
        }

        @Override
        public Builder deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return Choice.builder().nextStateName(node.get("Next").asText()).condition(this.conditionDeserializer.deserializeCondition(node));
        }
    }

    @JsonDeserialize(using=ChoiceDeserializer.class)
    public static final class Builder
    implements Buildable<Choice> {
        private Condition.Builder condition = Condition.NULL_BUILDER;
        private Transition.Builder transition = Transition.NULL_BUILDER;

        private Builder() {
        }

        public Builder condition(Condition.Builder conditionBuilder) {
            this.condition = conditionBuilder;
            return this;
        }

        @JsonProperty(value="Next")
        private Builder nextStateName(String nextStateName) {
            return this.transition(NextStateTransition.builder().nextStateName(nextStateName));
        }

        public Builder transition(NextStateTransition.Builder transition) {
            this.transition = transition;
            return this;
        }

        @Override
        public Choice build() {
            return new Choice(this);
        }
    }
}

