/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.sdb;

import com.amazonaws.services.simpledb.AmazonSimpleDB;
import com.amazonaws.services.simpledb.model.ListDomainsRequest;
import com.amazonaws.services.simpledb.model.ListDomainsResult;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.aws.common.AwsExchangeUtil;
import org.apache.camel.component.aws.sdb.AbstractSdbCommand;
import org.apache.camel.component.aws.sdb.SdbConfiguration;

public class ListDomainsCommand
extends AbstractSdbCommand {
    public ListDomainsCommand(AmazonSimpleDB sdbClient, SdbConfiguration configuration, Exchange exchange) {
        super(sdbClient, configuration, exchange);
    }

    @Override
    public void execute() {
        ListDomainsRequest request = new ListDomainsRequest().withMaxNumberOfDomains(this.determineMaxNumberOfDomains()).withNextToken(this.determineNextToken());
        this.log.trace("Sending request [{}] for exchange [{}]...", (Object)request, (Object)this.exchange);
        ListDomainsResult result = this.sdbClient.listDomains(request);
        this.log.trace("Received result [{}]", (Object)result);
        Message msg = AwsExchangeUtil.getMessageForResponse(this.exchange);
        msg.setHeader("CamelAwsSdbNextToken", (Object)result.getNextToken());
        msg.setHeader("CamelAwsSdbDomainNames", result.getDomainNames());
    }

    protected Integer determineMaxNumberOfDomains() {
        Integer maxNumberOfDomains = (Integer)this.exchange.getIn().getHeader("CamelAwsSdbMaxNumberOfDomains", Integer.class);
        if (maxNumberOfDomains == null) {
            maxNumberOfDomains = this.configuration.getMaxNumberOfDomains();
        }
        return maxNumberOfDomains;
    }
}

