/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.swf;

import com.amazonaws.services.simpleworkflow.flow.ActivityExecutionContext;
import com.amazonaws.services.simpleworkflow.flow.ActivityExecutionContextProviderImpl;
import com.amazonaws.services.simpleworkflow.flow.ActivityFailureException;
import com.amazonaws.services.simpleworkflow.flow.DataConverter;
import com.amazonaws.services.simpleworkflow.flow.DataConverterException;
import com.amazonaws.services.simpleworkflow.flow.common.WorkflowExecutionUtils;
import com.amazonaws.services.simpleworkflow.flow.generic.ActivityImplementationBase;
import com.amazonaws.services.simpleworkflow.flow.worker.ActivityTypeExecutionOptions;
import com.amazonaws.services.simpleworkflow.flow.worker.ActivityTypeRegistrationOptions;
import com.amazonaws.services.simpleworkflow.flow.worker.CurrentActivityExecutionContext;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.CancellationException;
import org.apache.camel.component.aws.swf.SWFActivityConsumer;

public class CamelActivityImplementation
extends ActivityImplementationBase {
    private final ActivityTypeExecutionOptions executionOptions;
    private final ActivityTypeRegistrationOptions registrationOptions;
    private final DataConverter converter;
    private final SWFActivityConsumer swfWorkflowConsumer;
    private final ActivityExecutionContextProviderImpl contextProvider = new ActivityExecutionContextProviderImpl();

    public CamelActivityImplementation(SWFActivityConsumer swfWorkflowConsumer, ActivityTypeRegistrationOptions activityTypeRegistrationOptions, ActivityTypeExecutionOptions activityTypeExecutionOptions, DataConverter converter) {
        this.swfWorkflowConsumer = swfWorkflowConsumer;
        this.registrationOptions = activityTypeRegistrationOptions;
        this.executionOptions = activityTypeExecutionOptions;
        this.converter = converter;
    }

    @Override
    public ActivityTypeRegistrationOptions getRegistrationOptions() {
        return this.registrationOptions;
    }

    @Override
    public ActivityTypeExecutionOptions getExecutionOptions() {
        return this.executionOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String execute(String input, ActivityExecutionContext context) throws ActivityFailureException, CancellationException {
        Object[] inputParameters = this.converter.fromData(input, Object[].class);
        CurrentActivityExecutionContext.set(context);
        Object result = null;
        ActivityExecutionContext executionContext = this.contextProvider.getActivityExecutionContext();
        String taskToken = executionContext.getTaskToken();
        try {
            result = this.swfWorkflowConsumer.processActivity(inputParameters, taskToken);
        }
        catch (InvocationTargetException invocationException) {
            this.throwActivityFailureException(invocationException.getTargetException() != null ? invocationException.getTargetException() : invocationException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.throwActivityFailureException(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.throwActivityFailureException(illegalAccessException);
        }
        catch (Exception e) {
            this.throwActivityFailureException(e);
        }
        finally {
            CurrentActivityExecutionContext.unset();
        }
        String resultSerialized = this.converter.toData(result);
        return resultSerialized;
    }

    void throwActivityFailureException(Throwable exception) throws ActivityFailureException, CancellationException {
        if (exception instanceof CancellationException) {
            throw (CancellationException)exception;
        }
        String reason = WorkflowExecutionUtils.truncateReason(exception.getMessage());
        String details = null;
        try {
            details = this.converter.toData(exception);
        }
        catch (DataConverterException dataConverterException) {
            if (dataConverterException.getCause() == null) {
                dataConverterException.initCause(exception);
            }
            throw dataConverterException;
        }
        throw new ActivityFailureException(reason, details);
    }
}

