/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.swf;

import com.amazonaws.services.simpleworkflow.flow.DataConverter;
import com.amazonaws.services.simpleworkflow.flow.JsonDataConverter;
import com.amazonaws.services.simpleworkflow.flow.generic.ActivityImplementation;
import com.amazonaws.services.simpleworkflow.flow.generic.ActivityImplementationFactory;
import com.amazonaws.services.simpleworkflow.flow.worker.ActivityTypeExecutionOptions;
import com.amazonaws.services.simpleworkflow.flow.worker.ActivityTypeRegistrationOptions;
import com.amazonaws.services.simpleworkflow.model.ActivityType;
import java.util.ArrayList;
import org.apache.camel.component.aws.swf.CamelActivityImplementation;
import org.apache.camel.component.aws.swf.SWFActivityConsumer;
import org.apache.camel.component.aws.swf.SWFConfiguration;

public class CamelActivityImplementationFactory
extends ActivityImplementationFactory {
    private SWFActivityConsumer swfWorkflowConsumer;
    private SWFConfiguration configuration;

    public CamelActivityImplementationFactory(SWFActivityConsumer swfWorkflowConsumer, SWFConfiguration configuration) {
        this.swfWorkflowConsumer = swfWorkflowConsumer;
        this.configuration = configuration;
    }

    @Override
    public Iterable<ActivityType> getActivityTypesToRegister() {
        ArrayList<ActivityType> activityTypes = new ArrayList<ActivityType>(1);
        ActivityType activityType = new ActivityType();
        activityType.setName(this.configuration.getEventName());
        activityType.setVersion(this.configuration.getVersion());
        activityTypes.add(activityType);
        return activityTypes;
    }

    @Override
    public ActivityImplementation getActivityImplementation(ActivityType activityType) {
        ActivityTypeExecutionOptions activityTypeExecutionOptions = this.configuration.getActivityTypeExecutionOptions() != null ? this.configuration.getActivityTypeExecutionOptions() : new ActivityTypeExecutionOptions();
        ActivityTypeRegistrationOptions activityTypeRegistrationOptions = this.configuration.getActivityTypeRegistrationOptions() != null ? this.configuration.getActivityTypeRegistrationOptions() : new ActivityTypeRegistrationOptions();
        DataConverter dataConverter = this.configuration.getDataConverter() != null ? this.configuration.getDataConverter() : new JsonDataConverter();
        return new CamelActivityImplementation(this.swfWorkflowConsumer, activityTypeRegistrationOptions, activityTypeExecutionOptions, dataConverter);
    }
}

