/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.swf;

import com.amazonaws.services.simpleworkflow.flow.DynamicActivitiesClient;
import com.amazonaws.services.simpleworkflow.flow.DynamicActivitiesClientImpl;
import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.amazonaws.services.simpleworkflow.model.ActivityType;
import org.apache.camel.component.aws.swf.SWFConfiguration;

public class CamelSWFActivityClient {
    private final DynamicActivitiesClient dynamicActivitiesClient;
    private SWFConfiguration configuration;

    public CamelSWFActivityClient(SWFConfiguration configuration) {
        this.configuration = configuration;
        this.dynamicActivitiesClient = this.getDynamicActivitiesClient();
    }

    public Object scheduleActivity(String eventName, String version, Object input) {
        ActivityType activity = new ActivityType();
        activity.setName(eventName);
        activity.setVersion(version);
        Promise<?>[] promises = this.asPromiseArray(input);
        Promise<Object> promise = this.dynamicActivitiesClient.scheduleActivity(activity, promises, this.configuration.getActivitySchedulingOptions(), Object.class, (Promise<?>[])null);
        return promise;
    }

    protected Promise<?>[] asPromiseArray(Object input) {
        Promise[] promises;
        if (input instanceof Object[]) {
            Object[] inputArray = (Object[])input;
            promises = new Promise[inputArray.length];
            for (int i = 0; i < inputArray.length; ++i) {
                promises[i] = Promise.asPromise(inputArray[i]);
            }
        } else {
            promises = new Promise[]{input instanceof Promise ? (Promise)input : Promise.asPromise(input)};
        }
        return promises;
    }

    DynamicActivitiesClient getDynamicActivitiesClient() {
        return new DynamicActivitiesClientImpl(null, this.configuration.getDataConverter());
    }
}

