/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.swf;

import com.amazonaws.services.simpleworkflow.flow.worker.GenericActivityWorker;
import java.util.Arrays;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.aws.swf.CamelActivityImplementationFactory;
import org.apache.camel.component.aws.swf.SWFConfiguration;
import org.apache.camel.component.aws.swf.SWFEndpoint;
import org.apache.camel.component.aws.swf.SWFWorkflowProducer;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SWFActivityConsumer
extends DefaultConsumer {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(SWFWorkflowProducer.class);
    private SWFEndpoint endpoint;
    private final SWFConfiguration configuration;
    private GenericActivityWorker genericWorker;
    private transient String swfActivityConsumerToString;

    public SWFActivityConsumer(SWFEndpoint endpoint, Processor processor, SWFConfiguration configuration) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        this.configuration = configuration;
    }

    public Object processActivity(Object[] inputParameters, String taskToken) throws Exception {
        LOGGER.debug("Processing activity task: " + Arrays.toString(inputParameters));
        Exchange exchange = this.endpoint.createExchange(inputParameters, "CamelSWFActionExecute");
        exchange.getIn().setHeader("CamelSWFTaskToken", (Object)taskToken);
        this.getProcessor().process(exchange);
        return this.endpoint.getResult(exchange);
    }

    protected void doStart() throws Exception {
        CamelActivityImplementationFactory factory = new CamelActivityImplementationFactory(this, this.configuration);
        this.genericWorker = new GenericActivityWorker(this.endpoint.getSWClient(), this.configuration.getDomainName(), this.configuration.getActivityList());
        this.genericWorker.setActivityImplementationFactory(factory);
        this.genericWorker.setTaskExecutorThreadPoolSize(this.configuration.getActivityThreadPoolSize());
        this.genericWorker.start();
        super.doStart();
    }

    protected void doStop() throws Exception {
        this.genericWorker.setDisableServiceShutdownOnStop(true);
        this.genericWorker.shutdownNow();
        super.doStop();
    }

    public String toString() {
        if (this.swfActivityConsumerToString == null) {
            this.swfActivityConsumerToString = "SWFActivityConsumer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.swfActivityConsumerToString;
    }
}

