/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.http.rest;

import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.StreamResponse;
import com.azure.core.implementation.TypeUtil;
import com.azure.core.implementation.http.rest.ErrorOptions;
import com.azure.core.implementation.http.rest.RequestDataConfiguration;
import com.azure.core.implementation.http.rest.RestProxyBase;
import com.azure.core.implementation.http.rest.RestProxyUtils;
import com.azure.core.implementation.http.rest.SwaggerInterfaceParser;
import com.azure.core.implementation.http.rest.SwaggerMethodParser;
import com.azure.core.implementation.serializer.HttpResponseDecoder;
import com.azure.core.util.Base64Url;
import com.azure.core.util.BinaryData;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.core.util.tracing.TracerProxy;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import java.util.function.Consumer;
import reactor.core.CorePublisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Signal;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

public class AsyncRestProxy
extends RestProxyBase {
    public AsyncRestProxy(HttpPipeline httpPipeline, SerializerAdapter serializer, SwaggerInterfaceParser interfaceParser) {
        super(httpPipeline, serializer, interfaceParser);
    }

    Mono<HttpResponse> send(HttpRequest request, com.azure.core.util.Context contextData) {
        return this.httpPipeline.send(request, contextData);
    }

    @Override
    public Object invoke(Object proxy, Method method, RequestOptions options, EnumSet<ErrorOptions> errorOptions, Consumer<HttpRequest> requestCallback, SwaggerMethodParser methodParser, HttpRequest request, com.azure.core.util.Context context) {
        RestProxyUtils.validateResumeOperationIsNotPresent(method);
        context = AsyncRestProxy.startTracingSpan(methodParser, context);
        if (options != null && requestCallback != null) {
            requestCallback.accept(request);
        }
        com.azure.core.util.Context finalContext = context;
        Mono<HttpResponse> asyncResponse = RestProxyUtils.validateLengthAsync(request).flatMap(r -> this.send((HttpRequest)r, finalContext));
        Mono<HttpResponseDecoder.HttpDecodedResponse> asyncDecodedResponse = this.decoder.decode(asyncResponse, methodParser);
        return this.handleRestReturnType(asyncDecodedResponse, methodParser, methodParser.getReturnType(), context, options, errorOptions);
    }

    private Mono<HttpResponseDecoder.HttpDecodedResponse> ensureExpectedStatus(Mono<HttpResponseDecoder.HttpDecodedResponse> asyncDecodedResponse, SwaggerMethodParser methodParser, RequestOptions options, EnumSet<ErrorOptions> errorOptions) {
        return asyncDecodedResponse.flatMap(decodedResponse -> {
            int responseStatusCode = decodedResponse.getSourceResponse().getStatusCode();
            if (methodParser.isExpectedResponseStatusCode(responseStatusCode) || options != null && errorOptions.contains((Object)ErrorOptions.NO_THROW)) {
                return Mono.just(decodedResponse);
            }
            return decodedResponse.getSourceResponse().getBodyAsByteArray().map(bytes -> this.instantiateUnexpectedException(methodParser.getUnexpectedException(responseStatusCode), decodedResponse.getSourceResponse(), (byte[])bytes, decodedResponse.getDecodedBody((byte[])bytes))).switchIfEmpty(Mono.fromSupplier(() -> this.instantiateUnexpectedException(methodParser.getUnexpectedException(responseStatusCode), decodedResponse.getSourceResponse(), null, null))).flatMap(Mono::error);
        });
    }

    private Mono<?> handleRestResponseReturnType(HttpResponseDecoder.HttpDecodedResponse response, SwaggerMethodParser methodParser, Type entityType) {
        if (methodParser.isStreamResponse()) {
            return Mono.fromSupplier(() -> new StreamResponse(response.getSourceResponse()));
        }
        if (TypeUtil.isTypeOrSubTypeOf(entityType, Response.class)) {
            Type bodyType = TypeUtil.getRestResponseBodyType(entityType);
            if (TypeUtil.isTypeOrSubTypeOf(bodyType, Void.class)) {
                return response.getSourceResponse().getBody().ignoreElements().then(Mono.fromCallable(() -> this.createResponse(response, entityType, null)));
            }
            return this.handleBodyReturnType(response, methodParser, bodyType).map(bodyAsObject -> this.createResponse(response, entityType, bodyAsObject)).switchIfEmpty(Mono.fromCallable(() -> this.createResponse(response, entityType, null)));
        }
        return this.handleBodyReturnType(response, methodParser, entityType);
    }

    Mono<?> handleBodyReturnType(HttpResponseDecoder.HttpDecodedResponse response, SwaggerMethodParser methodParser, Type entityType) {
        Mono<Object> asyncResult;
        int responseStatusCode = response.getSourceResponse().getStatusCode();
        HttpMethod httpMethod = methodParser.getHttpMethod();
        Type returnValueWireType = methodParser.getReturnValueWireType();
        if (httpMethod == HttpMethod.HEAD && (TypeUtil.isTypeOrSubTypeOf(entityType, Boolean.TYPE) || TypeUtil.isTypeOrSubTypeOf(entityType, Boolean.class))) {
            boolean isSuccess = responseStatusCode / 100 == 2;
            asyncResult = Mono.just(isSuccess);
        } else if (TypeUtil.isTypeOrSubTypeOf(entityType, byte[].class)) {
            Mono<byte[]> responseBodyBytesAsync = response.getSourceResponse().getBodyAsByteArray();
            if (returnValueWireType == Base64Url.class) {
                responseBodyBytesAsync = responseBodyBytesAsync.mapNotNull(base64UrlBytes -> new Base64Url((byte[])base64UrlBytes).decodedBytes());
            }
            asyncResult = responseBodyBytesAsync;
        } else {
            asyncResult = FluxUtil.isFluxByteBuffer(entityType) ? Mono.just(response.getSourceResponse().getBody()) : (TypeUtil.isTypeOrSubTypeOf(entityType, BinaryData.class) ? BinaryData.fromFlux(response.getSourceResponse().getBody()) : (TypeUtil.isTypeOrSubTypeOf(entityType, InputStream.class) ? response.getSourceResponse().getBodyAsInputStream() : response.getSourceResponse().getBodyAsByteArray().mapNotNull(response::getDecodedBody)));
        }
        return asyncResult;
    }

    private Object handleRestReturnType(Mono<HttpResponseDecoder.HttpDecodedResponse> asyncHttpDecodedResponse, SwaggerMethodParser methodParser, Type returnType, com.azure.core.util.Context context, RequestOptions options, EnumSet<ErrorOptions> errorOptionsSet) {
        CorePublisher<Object> result;
        Mono<HttpResponseDecoder.HttpDecodedResponse> asyncExpectedResponse = this.ensureExpectedStatus(asyncHttpDecodedResponse, methodParser, options, errorOptionsSet).doOnEach(this::endTracingSpan).contextWrite(Context.of("TRACING_CONTEXT", context));
        if (TypeUtil.isTypeOrSubTypeOf(returnType, Mono.class)) {
            Type monoTypeParam = TypeUtil.getTypeArgument(returnType);
            result = TypeUtil.isTypeOrSubTypeOf(monoTypeParam, Void.class) ? asyncExpectedResponse.doOnNext(HttpResponseDecoder.HttpDecodedResponse::close).then() : asyncExpectedResponse.flatMap(response -> this.handleRestResponseReturnType((HttpResponseDecoder.HttpDecodedResponse)response, methodParser, monoTypeParam));
        } else if (FluxUtil.isFluxByteBuffer(returnType)) {
            result = asyncExpectedResponse.flatMapMany(ar -> ar.getSourceResponse().getBody());
        } else if (TypeUtil.isTypeOrSubTypeOf(returnType, Void.TYPE) || TypeUtil.isTypeOrSubTypeOf(returnType, Void.class)) {
            asyncExpectedResponse.doOnNext(HttpResponseDecoder.HttpDecodedResponse::close).block();
            result = null;
        } else {
            result = asyncExpectedResponse.flatMap(httpResponse -> this.handleRestResponseReturnType((HttpResponseDecoder.HttpDecodedResponse)httpResponse, methodParser, returnType)).block();
        }
        return result;
    }

    private void endTracingSpan(Signal<HttpResponseDecoder.HttpDecodedResponse> signal) {
        if (!TracerProxy.isTracingEnabled()) {
            return;
        }
        if (signal.isOnComplete() || signal.isOnSubscribe()) {
            return;
        }
        ContextView context = signal.getContextView();
        HttpResponseDecoder.HttpDecodedResponse httpDecodedResponse = signal.hasValue() ? signal.get() : null;
        Throwable throwable = signal.hasError() ? signal.getThrowable() : null;
        this.endTracingSpan(httpDecodedResponse, throwable, (com.azure.core.util.Context)context.getOrEmpty("TRACING_CONTEXT").get());
    }

    @Override
    public void updateRequest(RequestDataConfiguration requestDataConfiguration, SerializerAdapter serializerAdapter) throws IOException {
        boolean isJson = requestDataConfiguration.isJson();
        HttpRequest request = requestDataConfiguration.getHttpRequest();
        Object bodyContentObject = requestDataConfiguration.getBodyContent();
        SwaggerMethodParser methodParser = requestDataConfiguration.getMethodParser();
        if (AsyncRestProxy.supportsJsonSerializable(bodyContentObject.getClass())) {
            request.setBody(BinaryData.fromByteBuffer(AsyncRestProxy.serializeAsJsonSerializable(bodyContentObject)));
            return;
        }
        if (AsyncRestProxy.supportsXmlSerializable(bodyContentObject.getClass())) {
            request.setBody(BinaryData.fromByteBuffer(AsyncRestProxy.serializeAsXmlSerializable(bodyContentObject)));
            return;
        }
        if (isJson) {
            request.setBody(serializerAdapter.serializeToBytes(bodyContentObject, SerializerEncoding.JSON));
        } else if (FluxUtil.isFluxByteBuffer(methodParser.getBodyJavaType())) {
            request.setBody((Flux)bodyContentObject);
        } else if (bodyContentObject instanceof byte[]) {
            request.setBody((byte[])bodyContentObject);
        } else if (bodyContentObject instanceof String) {
            String bodyContentString = (String)bodyContentObject;
            if (!bodyContentString.isEmpty()) {
                request.setBody(bodyContentString);
            }
        } else if (bodyContentObject instanceof ByteBuffer) {
            request.setBody(Flux.just((ByteBuffer)bodyContentObject));
        } else {
            request.setBody(serializerAdapter.serializeToBytes(bodyContentObject, SerializerEncoding.fromHeaders(request.getHeaders())));
        }
    }
}

