/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.changefeed;

import com.azure.storage.blob.BlobContainerAsyncClient;
import com.azure.storage.blob.changefeed.Shard;
import com.azure.storage.blob.changefeed.ShardFactory;
import com.azure.storage.blob.changefeed.implementation.models.BlobChangefeedEventWrapper;
import com.azure.storage.blob.changefeed.implementation.models.ChangefeedCursor;
import com.azure.storage.blob.changefeed.implementation.models.SegmentCursor;
import com.azure.storage.blob.changefeed.implementation.models.ShardCursor;
import com.azure.storage.blob.changefeed.implementation.util.DownloadUtils;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.List;
import reactor.core.publisher.Flux;

class Segment {
    private static final String CHUNK_FILE_PATHS = "chunkFilePaths";
    private final BlobContainerAsyncClient client;
    private final String segmentPath;
    private final ChangefeedCursor changefeedCursor;
    private final SegmentCursor userCursor;
    private final ShardFactory shardFactory;

    Segment(BlobContainerAsyncClient client, String segmentPath, ChangefeedCursor changefeedCursor, SegmentCursor userCursor, ShardFactory shardFactory) {
        this.client = client;
        this.segmentPath = segmentPath;
        this.changefeedCursor = changefeedCursor;
        this.userCursor = userCursor;
        this.shardFactory = shardFactory;
    }

    Flux<BlobChangefeedEventWrapper> getEvents() {
        return DownloadUtils.downloadToByteArray(this.client, this.segmentPath).flatMap(DownloadUtils::parseJson).flatMapIterable(this::getShards).concatMap(Shard::getEvents);
    }

    private List<Shard> getShards(JsonNode node) {
        ArrayList<Shard> shards = new ArrayList<Shard>();
        for (JsonNode shard : node.withArray(CHUNK_FILE_PATHS)) {
            String shardPath = shard.asText().substring("$blobchangefeed".length() + 1);
            ShardCursor shardCursor = null;
            if (this.userCursor != null) {
                shardCursor = this.userCursor.getShardCursors().stream().filter(sc -> sc.getCurrentChunkPath().contains(shardPath)).findFirst().orElse(null);
            }
            shards.add(this.shardFactory.getShard(shardPath, this.changefeedCursor.toShardCursor(shardPath), shardCursor));
        }
        return shards;
    }
}

