/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.changefeed.implementation.models;

import com.azure.storage.blob.changefeed.implementation.models.ShardCursor;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class SegmentCursor {
    @JsonProperty(value="ShardCursors")
    private List<ShardCursor> shardCursors;
    @JsonProperty(value="CurrentShardPath")
    private String currentShardPath;
    @JsonProperty(value="SegmentPath")
    private String segmentPath;

    public SegmentCursor() {
    }

    public SegmentCursor(String segmentPath, List<ShardCursor> shardCursors, String currentShardPath) {
        this.segmentPath = segmentPath;
        this.shardCursors = shardCursors;
        this.currentShardPath = currentShardPath;
    }

    public SegmentCursor(String segmentPath, SegmentCursor userSegmentCursor) {
        this.segmentPath = segmentPath;
        ArrayList<ShardCursor> copy = new ArrayList<ShardCursor>();
        if (userSegmentCursor != null) {
            userSegmentCursor.getShardCursors().forEach(shardCursor -> copy.add(new ShardCursor(shardCursor.getCurrentChunkPath(), shardCursor.getBlockOffset(), shardCursor.getEventIndex())));
        }
        this.shardCursors = copy;
        this.currentShardPath = null;
    }

    public SegmentCursor toShardCursor(String shardPath) {
        return new SegmentCursor(this.segmentPath, this.shardCursors, shardPath);
    }

    public SegmentCursor toEventCursor(String chunkPath, long blockOffset, long eventIndex) {
        ArrayList<ShardCursor> copy = new ArrayList<ShardCursor>(this.shardCursors.size() + 1);
        boolean found = false;
        for (ShardCursor cursor : this.shardCursors) {
            if (cursor.getCurrentChunkPath().contains(this.currentShardPath)) {
                found = true;
                cursor.setCurrentChunkPath(chunkPath).setBlockOffset(blockOffset).setEventIndex(eventIndex);
            }
            copy.add(new ShardCursor(cursor.getCurrentChunkPath(), cursor.getBlockOffset(), cursor.getEventIndex()));
        }
        if (!found) {
            this.shardCursors.add(new ShardCursor(chunkPath, blockOffset, eventIndex));
            copy.add(new ShardCursor(chunkPath, blockOffset, eventIndex));
        }
        return new SegmentCursor(this.segmentPath, copy, this.currentShardPath);
    }

    public String getSegmentPath() {
        return this.segmentPath;
    }

    public List<ShardCursor> getShardCursors() {
        return this.shardCursors;
    }

    public String getCurrentShardPath() {
        return this.currentShardPath;
    }

    public SegmentCursor setSegmentPath(String segmentPath) {
        this.segmentPath = segmentPath;
        return this;
    }

    public SegmentCursor setShardCursors(List<ShardCursor> shardCursors) {
        this.shardCursors = shardCursors;
        return this;
    }

    public SegmentCursor setCurrentShardPath(String currentShardPath) {
        this.currentShardPath = currentShardPath;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SegmentCursor)) {
            return false;
        }
        SegmentCursor that = (SegmentCursor)o;
        return Objects.equals(this.getShardCursors(), that.getShardCursors()) && Objects.equals(this.getCurrentShardPath(), that.getCurrentShardPath()) && Objects.equals(this.getSegmentPath(), that.getSegmentPath());
    }

    public int hashCode() {
        return Objects.hash(this.getShardCursors(), this.getCurrentShardPath(), this.getSegmentPath());
    }
}

