/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.blob;

import com.azure.core.util.Context;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.models.BlockListType;
import com.azure.storage.common.StorageSharedKeyCredential;
import java.time.Duration;
import java.time.OffsetDateTime;
import org.apache.camel.CamelContext;
import org.apache.camel.component.azure.storage.blob.BlobComponent;
import org.apache.camel.component.azure.storage.blob.BlobConfiguration;
import org.apache.camel.component.azure.storage.blob.BlobOperationsDefinition;
import org.apache.camel.component.azure.storage.blob.BlobType;
import org.apache.camel.component.azure.storage.blob.CredentialType;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class BlobComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private BlobConfiguration getOrCreateConfiguration(BlobComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new BlobConfiguration());
        }
        return target.getConfiguration();
    }

    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        BlobComponent target = (BlobComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                this.getOrCreateConfiguration(target).setAccessKey(BlobComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                target.setAutowiredEnabled(BlobComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "blobname": 
            case "blobName": {
                this.getOrCreateConfiguration(target).setBlobName(BlobComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "bloboffset": 
            case "blobOffset": {
                this.getOrCreateConfiguration(target).setBlobOffset(BlobComponentConfigurer.property(camelContext, Long.TYPE, value));
                return true;
            }
            case "blobsequencenumber": 
            case "blobSequenceNumber": {
                this.getOrCreateConfiguration(target).setBlobSequenceNumber(BlobComponentConfigurer.property(camelContext, Long.class, value));
                return true;
            }
            case "blobtype": 
            case "blobType": {
                this.getOrCreateConfiguration(target).setBlobType(BlobComponentConfigurer.property(camelContext, BlobType.class, value));
                return true;
            }
            case "blocklisttype": 
            case "blockListType": {
                this.getOrCreateConfiguration(target).setBlockListType(BlobComponentConfigurer.property(camelContext, BlockListType.class, value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler(BlobComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "changefeedcontext": 
            case "changeFeedContext": {
                this.getOrCreateConfiguration(target).setChangeFeedContext(BlobComponentConfigurer.property(camelContext, Context.class, value));
                return true;
            }
            case "changefeedendtime": 
            case "changeFeedEndTime": {
                this.getOrCreateConfiguration(target).setChangeFeedEndTime(BlobComponentConfigurer.property(camelContext, OffsetDateTime.class, value));
                return true;
            }
            case "changefeedstarttime": 
            case "changeFeedStartTime": {
                this.getOrCreateConfiguration(target).setChangeFeedStartTime(BlobComponentConfigurer.property(camelContext, OffsetDateTime.class, value));
                return true;
            }
            case "closestreamafterread": 
            case "closeStreamAfterRead": {
                this.getOrCreateConfiguration(target).setCloseStreamAfterRead(BlobComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "closestreamafterwrite": 
            case "closeStreamAfterWrite": {
                this.getOrCreateConfiguration(target).setCloseStreamAfterWrite(BlobComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "commitblocklistlater": 
            case "commitBlockListLater": {
                this.getOrCreateConfiguration(target).setCommitBlockListLater(BlobComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "configuration": {
                target.setConfiguration(BlobComponentConfigurer.property(camelContext, BlobConfiguration.class, value));
                return true;
            }
            case "createappendblob": 
            case "createAppendBlob": {
                this.getOrCreateConfiguration(target).setCreateAppendBlob(BlobComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "createpageblob": 
            case "createPageBlob": {
                this.getOrCreateConfiguration(target).setCreatePageBlob(BlobComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "credentialtype": 
            case "credentialType": {
                this.getOrCreateConfiguration(target).setCredentialType(BlobComponentConfigurer.property(camelContext, CredentialType.class, value));
                return true;
            }
            case "credentials": {
                this.getOrCreateConfiguration(target).setCredentials(BlobComponentConfigurer.property(camelContext, StorageSharedKeyCredential.class, value));
                return true;
            }
            case "datacount": 
            case "dataCount": {
                this.getOrCreateConfiguration(target).setDataCount(BlobComponentConfigurer.property(camelContext, Long.class, value));
                return true;
            }
            case "downloadlinkexpiration": 
            case "downloadLinkExpiration": {
                this.getOrCreateConfiguration(target).setDownloadLinkExpiration(BlobComponentConfigurer.property(camelContext, Long.class, value));
                return true;
            }
            case "filedir": 
            case "fileDir": {
                this.getOrCreateConfiguration(target).setFileDir(BlobComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(BlobComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "maxresultsperpage": 
            case "maxResultsPerPage": {
                this.getOrCreateConfiguration(target).setMaxResultsPerPage(BlobComponentConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "maxretryrequests": 
            case "maxRetryRequests": {
                this.getOrCreateConfiguration(target).setMaxRetryRequests(BlobComponentConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "operation": {
                this.getOrCreateConfiguration(target).setOperation(BlobComponentConfigurer.property(camelContext, BlobOperationsDefinition.class, value));
                return true;
            }
            case "pageblobsize": 
            case "pageBlobSize": {
                this.getOrCreateConfiguration(target).setPageBlobSize(BlobComponentConfigurer.property(camelContext, Long.class, value));
                return true;
            }
            case "prefix": {
                this.getOrCreateConfiguration(target).setPrefix(BlobComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "regex": {
                this.getOrCreateConfiguration(target).setRegex(BlobComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "serviceclient": 
            case "serviceClient": {
                this.getOrCreateConfiguration(target).setServiceClient(BlobComponentConfigurer.property(camelContext, BlobServiceClient.class, value));
                return true;
            }
            case "sourceblobaccesskey": 
            case "sourceBlobAccessKey": {
                this.getOrCreateConfiguration(target).setSourceBlobAccessKey(BlobComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "timeout": {
                this.getOrCreateConfiguration(target).setTimeout(BlobComponentConfigurer.property(camelContext, Duration.class, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public String[] getAutowiredNames() {
        return new String[]{"serviceClient"};
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                return String.class;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return Boolean.TYPE;
            }
            case "blobname": 
            case "blobName": {
                return String.class;
            }
            case "bloboffset": 
            case "blobOffset": {
                return Long.TYPE;
            }
            case "blobsequencenumber": 
            case "blobSequenceNumber": {
                return Long.class;
            }
            case "blobtype": 
            case "blobType": {
                return BlobType.class;
            }
            case "blocklisttype": 
            case "blockListType": {
                return BlockListType.class;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "changefeedcontext": 
            case "changeFeedContext": {
                return Context.class;
            }
            case "changefeedendtime": 
            case "changeFeedEndTime": {
                return OffsetDateTime.class;
            }
            case "changefeedstarttime": 
            case "changeFeedStartTime": {
                return OffsetDateTime.class;
            }
            case "closestreamafterread": 
            case "closeStreamAfterRead": {
                return Boolean.TYPE;
            }
            case "closestreamafterwrite": 
            case "closeStreamAfterWrite": {
                return Boolean.TYPE;
            }
            case "commitblocklistlater": 
            case "commitBlockListLater": {
                return Boolean.TYPE;
            }
            case "configuration": {
                return BlobConfiguration.class;
            }
            case "createappendblob": 
            case "createAppendBlob": {
                return Boolean.TYPE;
            }
            case "createpageblob": 
            case "createPageBlob": {
                return Boolean.TYPE;
            }
            case "credentialtype": 
            case "credentialType": {
                return CredentialType.class;
            }
            case "credentials": {
                return StorageSharedKeyCredential.class;
            }
            case "datacount": 
            case "dataCount": {
                return Long.class;
            }
            case "downloadlinkexpiration": 
            case "downloadLinkExpiration": {
                return Long.class;
            }
            case "filedir": 
            case "fileDir": {
                return String.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "maxresultsperpage": 
            case "maxResultsPerPage": {
                return Integer.class;
            }
            case "maxretryrequests": 
            case "maxRetryRequests": {
                return Integer.TYPE;
            }
            case "operation": {
                return BlobOperationsDefinition.class;
            }
            case "pageblobsize": 
            case "pageBlobSize": {
                return Long.class;
            }
            case "prefix": {
                return String.class;
            }
            case "regex": {
                return String.class;
            }
            case "serviceclient": 
            case "serviceClient": {
                return BlobServiceClient.class;
            }
            case "sourceblobaccesskey": 
            case "sourceBlobAccessKey": {
                return String.class;
            }
            case "timeout": {
                return Duration.class;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        BlobComponent target = (BlobComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                return this.getOrCreateConfiguration(target).getAccessKey();
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return target.isAutowiredEnabled();
            }
            case "blobname": 
            case "blobName": {
                return this.getOrCreateConfiguration(target).getBlobName();
            }
            case "bloboffset": 
            case "blobOffset": {
                return this.getOrCreateConfiguration(target).getBlobOffset();
            }
            case "blobsequencenumber": 
            case "blobSequenceNumber": {
                return this.getOrCreateConfiguration(target).getBlobSequenceNumber();
            }
            case "blobtype": 
            case "blobType": {
                return this.getOrCreateConfiguration(target).getBlobType();
            }
            case "blocklisttype": 
            case "blockListType": {
                return this.getOrCreateConfiguration(target).getBlockListType();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "changefeedcontext": 
            case "changeFeedContext": {
                return this.getOrCreateConfiguration(target).getChangeFeedContext();
            }
            case "changefeedendtime": 
            case "changeFeedEndTime": {
                return this.getOrCreateConfiguration(target).getChangeFeedEndTime();
            }
            case "changefeedstarttime": 
            case "changeFeedStartTime": {
                return this.getOrCreateConfiguration(target).getChangeFeedStartTime();
            }
            case "closestreamafterread": 
            case "closeStreamAfterRead": {
                return this.getOrCreateConfiguration(target).isCloseStreamAfterRead();
            }
            case "closestreamafterwrite": 
            case "closeStreamAfterWrite": {
                return this.getOrCreateConfiguration(target).isCloseStreamAfterWrite();
            }
            case "commitblocklistlater": 
            case "commitBlockListLater": {
                return this.getOrCreateConfiguration(target).isCommitBlockListLater();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "createappendblob": 
            case "createAppendBlob": {
                return this.getOrCreateConfiguration(target).isCreateAppendBlob();
            }
            case "createpageblob": 
            case "createPageBlob": {
                return this.getOrCreateConfiguration(target).isCreatePageBlob();
            }
            case "credentialtype": 
            case "credentialType": {
                return this.getOrCreateConfiguration(target).getCredentialType();
            }
            case "credentials": {
                return this.getOrCreateConfiguration(target).getCredentials();
            }
            case "datacount": 
            case "dataCount": {
                return this.getOrCreateConfiguration(target).getDataCount();
            }
            case "downloadlinkexpiration": 
            case "downloadLinkExpiration": {
                return this.getOrCreateConfiguration(target).getDownloadLinkExpiration();
            }
            case "filedir": 
            case "fileDir": {
                return this.getOrCreateConfiguration(target).getFileDir();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "maxresultsperpage": 
            case "maxResultsPerPage": {
                return this.getOrCreateConfiguration(target).getMaxResultsPerPage();
            }
            case "maxretryrequests": 
            case "maxRetryRequests": {
                return this.getOrCreateConfiguration(target).getMaxRetryRequests();
            }
            case "operation": {
                return this.getOrCreateConfiguration(target).getOperation();
            }
            case "pageblobsize": 
            case "pageBlobSize": {
                return this.getOrCreateConfiguration(target).getPageBlobSize();
            }
            case "prefix": {
                return this.getOrCreateConfiguration(target).getPrefix();
            }
            case "regex": {
                return this.getOrCreateConfiguration(target).getRegex();
            }
            case "serviceclient": 
            case "serviceClient": {
                return this.getOrCreateConfiguration(target).getServiceClient();
            }
            case "sourceblobaccesskey": 
            case "sourceBlobAccessKey": {
                return this.getOrCreateConfiguration(target).getSourceBlobAccessKey();
            }
            case "timeout": {
                return this.getOrCreateConfiguration(target).getTimeout();
            }
        }
        return null;
    }
}

