/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.blob;

import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.models.BlobItem;
import com.azure.storage.blob.models.BlobStorageException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.ExtendedExchange;
import org.apache.camel.Processor;
import org.apache.camel.component.azure.storage.blob.BlobEndpoint;
import org.apache.camel.component.azure.storage.blob.client.BlobClientWrapper;
import org.apache.camel.component.azure.storage.blob.client.BlobContainerClientWrapper;
import org.apache.camel.component.azure.storage.blob.operations.BlobContainerOperations;
import org.apache.camel.component.azure.storage.blob.operations.BlobOperationResponse;
import org.apache.camel.component.azure.storage.blob.operations.BlobOperations;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.ScheduledBatchPollingConsumer;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlobConsumer
extends ScheduledBatchPollingConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(BlobConsumer.class);

    public BlobConsumer(BlobEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
    }

    @Override
    protected int poll() throws Exception {
        String containerName = this.getEndpoint().getConfiguration().getContainerName();
        String blobName = this.getEndpoint().getConfiguration().getBlobName();
        BlobContainerClient blobContainerClient = this.getEndpoint().getBlobServiceClient().getBlobContainerClient(containerName);
        try {
            Queue<Exchange> exchanges;
            if (ObjectHelper.isNotEmpty(blobName)) {
                Exchange exchange = this.createExchangeFromBlob(blobName, blobContainerClient);
                exchanges = new LinkedList<Exchange>();
                exchanges.add(exchange);
            } else {
                exchanges = this.createBatchExchangesFromContainer(blobContainerClient);
            }
            return this.processBatch(CastUtils.cast(exchanges));
        }
        catch (BlobStorageException ex) {
            if (404 == ex.getStatusCode()) {
                return 0;
            }
            throw ex;
        }
    }

    private Exchange createExchangeFromBlob(String blobName, BlobContainerClient blobContainerClient) throws IOException {
        BlobClientWrapper clientWrapper = new BlobClientWrapper(blobContainerClient.getBlobClient(blobName));
        BlobOperations operations = new BlobOperations(this.getEndpoint().getConfiguration(), clientWrapper);
        Exchange exchange = this.createExchange(true);
        BlobOperationResponse response = !ObjectHelper.isEmpty(this.getEndpoint().getConfiguration().getFileDir()) ? operations.downloadBlobToFile(exchange) : operations.getBlob(exchange);
        this.getEndpoint().setResponseOnExchange(response, exchange);
        exchange.getIn().setHeader("CamelAzureStorageBlobBlobName", blobName);
        return exchange;
    }

    private Queue<Exchange> createBatchExchangesFromContainer(BlobContainerClient blobContainerClient) throws IOException {
        BlobContainerClientWrapper containerClientWrapper = new BlobContainerClientWrapper(blobContainerClient);
        BlobContainerOperations containerOperations = new BlobContainerOperations(this.getEndpoint().getConfiguration(), containerClientWrapper);
        List blobs = (List)containerOperations.listBlobs(null).getBody();
        LinkedList<Exchange> exchanges = new LinkedList<Exchange>();
        for (BlobItem blobItem : blobs) {
            exchanges.add(this.createExchangeFromBlob(blobItem.getName(), blobContainerClient));
        }
        return exchanges;
    }

    @Override
    public BlobEndpoint getEndpoint() {
        return (BlobEndpoint)super.getEndpoint();
    }

    @Override
    public int processBatch(Queue<Object> exchanges) {
        int total = exchanges.size();
        for (int index = 0; index < total && this.isBatchAllowed(); ++index) {
            Exchange exchange = ObjectHelper.cast(Exchange.class, exchanges.poll());
            exchange.setProperty(ExchangePropertyKey.BATCH_INDEX, (Object)index);
            exchange.setProperty(ExchangePropertyKey.BATCH_SIZE, (Object)total);
            exchange.setProperty(ExchangePropertyKey.BATCH_COMPLETE, (Object)(index == total - 1 ? 1 : 0));
            this.pendingExchanges = total - index - 1;
            exchange.adapt(ExtendedExchange.class).addOnCompletion(new Synchronization(){

                @Override
                public void onComplete(Exchange exchange) {
                    LOG.trace("Completed from processing all exchanges...");
                }

                @Override
                public void onFailure(Exchange exchange) {
                    BlobConsumer.this.processRollback(exchange);
                }
            });
            AsyncCallback cb = this.defaultConsumerCallback(exchange, true);
            this.getAsyncProcessor().process(exchange, cb);
        }
        return total;
    }

    protected void processRollback(Exchange exchange) {
        Exception cause = exchange.getException();
        if (cause != null) {
            this.getExceptionHandler().handleException("Error during processing exchange. Will attempt to process the message on next poll.", exchange, cause);
        }
    }
}

