/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.blob;

import com.azure.core.util.Context;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.models.BlockListType;
import com.azure.storage.common.StorageSharedKeyCredential;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.azure.storage.blob.BlobEndpoint;
import org.apache.camel.component.azure.storage.blob.BlobOperationsDefinition;
import org.apache.camel.component.azure.storage.blob.BlobType;
import org.apache.camel.component.azure.storage.blob.CredentialType;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PollingConsumerPollStrategy;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class BlobEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        BlobEndpoint target = (BlobEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                target.getConfiguration().setAccessKey(BlobEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "backofferrorthreshold": 
            case "backoffErrorThreshold": {
                target.setBackoffErrorThreshold(BlobEndpointConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "backoffidlethreshold": 
            case "backoffIdleThreshold": {
                target.setBackoffIdleThreshold(BlobEndpointConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "backoffmultiplier": 
            case "backoffMultiplier": {
                target.setBackoffMultiplier(BlobEndpointConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "blobname": 
            case "blobName": {
                target.getConfiguration().setBlobName(BlobEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "bloboffset": 
            case "blobOffset": {
                target.getConfiguration().setBlobOffset(BlobEndpointConfigurer.property(camelContext, Long.TYPE, value));
                return true;
            }
            case "blobsequencenumber": 
            case "blobSequenceNumber": {
                target.getConfiguration().setBlobSequenceNumber(BlobEndpointConfigurer.property(camelContext, Long.class, value));
                return true;
            }
            case "blobserviceclient": 
            case "blobServiceClient": {
                target.setBlobServiceClient(BlobEndpointConfigurer.property(camelContext, BlobServiceClient.class, value));
                return true;
            }
            case "blobtype": 
            case "blobType": {
                target.getConfiguration().setBlobType(BlobEndpointConfigurer.property(camelContext, BlobType.class, value));
                return true;
            }
            case "blocklisttype": 
            case "blockListType": {
                target.getConfiguration().setBlockListType(BlobEndpointConfigurer.property(camelContext, BlockListType.class, value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler(BlobEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "changefeedcontext": 
            case "changeFeedContext": {
                target.getConfiguration().setChangeFeedContext(BlobEndpointConfigurer.property(camelContext, Context.class, value));
                return true;
            }
            case "changefeedendtime": 
            case "changeFeedEndTime": {
                target.getConfiguration().setChangeFeedEndTime(BlobEndpointConfigurer.property(camelContext, OffsetDateTime.class, value));
                return true;
            }
            case "changefeedstarttime": 
            case "changeFeedStartTime": {
                target.getConfiguration().setChangeFeedStartTime(BlobEndpointConfigurer.property(camelContext, OffsetDateTime.class, value));
                return true;
            }
            case "closestreamafterread": 
            case "closeStreamAfterRead": {
                target.getConfiguration().setCloseStreamAfterRead(BlobEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "closestreamafterwrite": 
            case "closeStreamAfterWrite": {
                target.getConfiguration().setCloseStreamAfterWrite(BlobEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "commitblocklistlater": 
            case "commitBlockListLater": {
                target.getConfiguration().setCommitBlockListLater(BlobEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "createappendblob": 
            case "createAppendBlob": {
                target.getConfiguration().setCreateAppendBlob(BlobEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "createpageblob": 
            case "createPageBlob": {
                target.getConfiguration().setCreatePageBlob(BlobEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "credentialtype": 
            case "credentialType": {
                target.getConfiguration().setCredentialType(BlobEndpointConfigurer.property(camelContext, CredentialType.class, value));
                return true;
            }
            case "credentials": {
                target.getConfiguration().setCredentials(BlobEndpointConfigurer.property(camelContext, StorageSharedKeyCredential.class, value));
                return true;
            }
            case "datacount": 
            case "dataCount": {
                target.getConfiguration().setDataCount(BlobEndpointConfigurer.property(camelContext, Long.class, value));
                return true;
            }
            case "delay": {
                target.setDelay(BlobEndpointConfigurer.property(camelContext, Long.TYPE, value));
                return true;
            }
            case "downloadlinkexpiration": 
            case "downloadLinkExpiration": {
                target.getConfiguration().setDownloadLinkExpiration(BlobEndpointConfigurer.property(camelContext, Long.class, value));
                return true;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                target.setExceptionHandler(BlobEndpointConfigurer.property(camelContext, ExceptionHandler.class, value));
                return true;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                target.setExchangePattern(BlobEndpointConfigurer.property(camelContext, ExchangePattern.class, value));
                return true;
            }
            case "filedir": 
            case "fileDir": {
                target.getConfiguration().setFileDir(BlobEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "greedy": {
                target.setGreedy(BlobEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "initialdelay": 
            case "initialDelay": {
                target.setInitialDelay(BlobEndpointConfigurer.property(camelContext, Long.TYPE, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(BlobEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "maxresultsperpage": 
            case "maxResultsPerPage": {
                target.getConfiguration().setMaxResultsPerPage(BlobEndpointConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "maxretryrequests": 
            case "maxRetryRequests": {
                target.getConfiguration().setMaxRetryRequests(BlobEndpointConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "operation": {
                target.getConfiguration().setOperation(BlobEndpointConfigurer.property(camelContext, BlobOperationsDefinition.class, value));
                return true;
            }
            case "pageblobsize": 
            case "pageBlobSize": {
                target.getConfiguration().setPageBlobSize(BlobEndpointConfigurer.property(camelContext, Long.class, value));
                return true;
            }
            case "pollstrategy": 
            case "pollStrategy": {
                target.setPollStrategy(BlobEndpointConfigurer.property(camelContext, PollingConsumerPollStrategy.class, value));
                return true;
            }
            case "prefix": {
                target.getConfiguration().setPrefix(BlobEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "regex": {
                target.getConfiguration().setRegex(BlobEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "repeatcount": 
            case "repeatCount": {
                target.setRepeatCount(BlobEndpointConfigurer.property(camelContext, Long.TYPE, value));
                return true;
            }
            case "runlogginglevel": 
            case "runLoggingLevel": {
                target.setRunLoggingLevel(BlobEndpointConfigurer.property(camelContext, LoggingLevel.class, value));
                return true;
            }
            case "scheduledexecutorservice": 
            case "scheduledExecutorService": {
                target.setScheduledExecutorService(BlobEndpointConfigurer.property(camelContext, ScheduledExecutorService.class, value));
                return true;
            }
            case "scheduler": {
                target.setScheduler(BlobEndpointConfigurer.property(camelContext, Object.class, value));
                return true;
            }
            case "schedulerproperties": 
            case "schedulerProperties": {
                target.setSchedulerProperties(BlobEndpointConfigurer.property(camelContext, Map.class, value));
                return true;
            }
            case "sendemptymessagewhenidle": 
            case "sendEmptyMessageWhenIdle": {
                target.setSendEmptyMessageWhenIdle(BlobEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "serviceclient": 
            case "serviceClient": {
                target.getConfiguration().setServiceClient(BlobEndpointConfigurer.property(camelContext, BlobServiceClient.class, value));
                return true;
            }
            case "sourceblobaccesskey": 
            case "sourceBlobAccessKey": {
                target.getConfiguration().setSourceBlobAccessKey(BlobEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "startscheduler": 
            case "startScheduler": {
                target.setStartScheduler(BlobEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "timeunit": 
            case "timeUnit": {
                target.setTimeUnit(BlobEndpointConfigurer.property(camelContext, TimeUnit.class, value));
                return true;
            }
            case "timeout": {
                target.getConfiguration().setTimeout(BlobEndpointConfigurer.property(camelContext, Duration.class, value));
                return true;
            }
            case "usefixeddelay": 
            case "useFixedDelay": {
                target.setUseFixedDelay(BlobEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public String[] getAutowiredNames() {
        return new String[]{"serviceClient"};
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                return String.class;
            }
            case "backofferrorthreshold": 
            case "backoffErrorThreshold": {
                return Integer.TYPE;
            }
            case "backoffidlethreshold": 
            case "backoffIdleThreshold": {
                return Integer.TYPE;
            }
            case "backoffmultiplier": 
            case "backoffMultiplier": {
                return Integer.TYPE;
            }
            case "blobname": 
            case "blobName": {
                return String.class;
            }
            case "bloboffset": 
            case "blobOffset": {
                return Long.TYPE;
            }
            case "blobsequencenumber": 
            case "blobSequenceNumber": {
                return Long.class;
            }
            case "blobserviceclient": 
            case "blobServiceClient": {
                return BlobServiceClient.class;
            }
            case "blobtype": 
            case "blobType": {
                return BlobType.class;
            }
            case "blocklisttype": 
            case "blockListType": {
                return BlockListType.class;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "changefeedcontext": 
            case "changeFeedContext": {
                return Context.class;
            }
            case "changefeedendtime": 
            case "changeFeedEndTime": {
                return OffsetDateTime.class;
            }
            case "changefeedstarttime": 
            case "changeFeedStartTime": {
                return OffsetDateTime.class;
            }
            case "closestreamafterread": 
            case "closeStreamAfterRead": {
                return Boolean.TYPE;
            }
            case "closestreamafterwrite": 
            case "closeStreamAfterWrite": {
                return Boolean.TYPE;
            }
            case "commitblocklistlater": 
            case "commitBlockListLater": {
                return Boolean.TYPE;
            }
            case "createappendblob": 
            case "createAppendBlob": {
                return Boolean.TYPE;
            }
            case "createpageblob": 
            case "createPageBlob": {
                return Boolean.TYPE;
            }
            case "credentialtype": 
            case "credentialType": {
                return CredentialType.class;
            }
            case "credentials": {
                return StorageSharedKeyCredential.class;
            }
            case "datacount": 
            case "dataCount": {
                return Long.class;
            }
            case "delay": {
                return Long.TYPE;
            }
            case "downloadlinkexpiration": 
            case "downloadLinkExpiration": {
                return Long.class;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return ExceptionHandler.class;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return ExchangePattern.class;
            }
            case "filedir": 
            case "fileDir": {
                return String.class;
            }
            case "greedy": {
                return Boolean.TYPE;
            }
            case "initialdelay": 
            case "initialDelay": {
                return Long.TYPE;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "maxresultsperpage": 
            case "maxResultsPerPage": {
                return Integer.class;
            }
            case "maxretryrequests": 
            case "maxRetryRequests": {
                return Integer.TYPE;
            }
            case "operation": {
                return BlobOperationsDefinition.class;
            }
            case "pageblobsize": 
            case "pageBlobSize": {
                return Long.class;
            }
            case "pollstrategy": 
            case "pollStrategy": {
                return PollingConsumerPollStrategy.class;
            }
            case "prefix": {
                return String.class;
            }
            case "regex": {
                return String.class;
            }
            case "repeatcount": 
            case "repeatCount": {
                return Long.TYPE;
            }
            case "runlogginglevel": 
            case "runLoggingLevel": {
                return LoggingLevel.class;
            }
            case "scheduledexecutorservice": 
            case "scheduledExecutorService": {
                return ScheduledExecutorService.class;
            }
            case "scheduler": {
                return Object.class;
            }
            case "schedulerproperties": 
            case "schedulerProperties": {
                return Map.class;
            }
            case "sendemptymessagewhenidle": 
            case "sendEmptyMessageWhenIdle": {
                return Boolean.TYPE;
            }
            case "serviceclient": 
            case "serviceClient": {
                return BlobServiceClient.class;
            }
            case "sourceblobaccesskey": 
            case "sourceBlobAccessKey": {
                return String.class;
            }
            case "startscheduler": 
            case "startScheduler": {
                return Boolean.TYPE;
            }
            case "timeunit": 
            case "timeUnit": {
                return TimeUnit.class;
            }
            case "timeout": {
                return Duration.class;
            }
            case "usefixeddelay": 
            case "useFixedDelay": {
                return Boolean.TYPE;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        BlobEndpoint target = (BlobEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                return target.getConfiguration().getAccessKey();
            }
            case "backofferrorthreshold": 
            case "backoffErrorThreshold": {
                return target.getBackoffErrorThreshold();
            }
            case "backoffidlethreshold": 
            case "backoffIdleThreshold": {
                return target.getBackoffIdleThreshold();
            }
            case "backoffmultiplier": 
            case "backoffMultiplier": {
                return target.getBackoffMultiplier();
            }
            case "blobname": 
            case "blobName": {
                return target.getConfiguration().getBlobName();
            }
            case "bloboffset": 
            case "blobOffset": {
                return target.getConfiguration().getBlobOffset();
            }
            case "blobsequencenumber": 
            case "blobSequenceNumber": {
                return target.getConfiguration().getBlobSequenceNumber();
            }
            case "blobserviceclient": 
            case "blobServiceClient": {
                return target.getBlobServiceClient();
            }
            case "blobtype": 
            case "blobType": {
                return target.getConfiguration().getBlobType();
            }
            case "blocklisttype": 
            case "blockListType": {
                return target.getConfiguration().getBlockListType();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "changefeedcontext": 
            case "changeFeedContext": {
                return target.getConfiguration().getChangeFeedContext();
            }
            case "changefeedendtime": 
            case "changeFeedEndTime": {
                return target.getConfiguration().getChangeFeedEndTime();
            }
            case "changefeedstarttime": 
            case "changeFeedStartTime": {
                return target.getConfiguration().getChangeFeedStartTime();
            }
            case "closestreamafterread": 
            case "closeStreamAfterRead": {
                return target.getConfiguration().isCloseStreamAfterRead();
            }
            case "closestreamafterwrite": 
            case "closeStreamAfterWrite": {
                return target.getConfiguration().isCloseStreamAfterWrite();
            }
            case "commitblocklistlater": 
            case "commitBlockListLater": {
                return target.getConfiguration().isCommitBlockListLater();
            }
            case "createappendblob": 
            case "createAppendBlob": {
                return target.getConfiguration().isCreateAppendBlob();
            }
            case "createpageblob": 
            case "createPageBlob": {
                return target.getConfiguration().isCreatePageBlob();
            }
            case "credentialtype": 
            case "credentialType": {
                return target.getConfiguration().getCredentialType();
            }
            case "credentials": {
                return target.getConfiguration().getCredentials();
            }
            case "datacount": 
            case "dataCount": {
                return target.getConfiguration().getDataCount();
            }
            case "delay": {
                return target.getDelay();
            }
            case "downloadlinkexpiration": 
            case "downloadLinkExpiration": {
                return target.getConfiguration().getDownloadLinkExpiration();
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return target.getExceptionHandler();
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return target.getExchangePattern();
            }
            case "filedir": 
            case "fileDir": {
                return target.getConfiguration().getFileDir();
            }
            case "greedy": {
                return target.isGreedy();
            }
            case "initialdelay": 
            case "initialDelay": {
                return target.getInitialDelay();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "maxresultsperpage": 
            case "maxResultsPerPage": {
                return target.getConfiguration().getMaxResultsPerPage();
            }
            case "maxretryrequests": 
            case "maxRetryRequests": {
                return target.getConfiguration().getMaxRetryRequests();
            }
            case "operation": {
                return target.getConfiguration().getOperation();
            }
            case "pageblobsize": 
            case "pageBlobSize": {
                return target.getConfiguration().getPageBlobSize();
            }
            case "pollstrategy": 
            case "pollStrategy": {
                return target.getPollStrategy();
            }
            case "prefix": {
                return target.getConfiguration().getPrefix();
            }
            case "regex": {
                return target.getConfiguration().getRegex();
            }
            case "repeatcount": 
            case "repeatCount": {
                return target.getRepeatCount();
            }
            case "runlogginglevel": 
            case "runLoggingLevel": {
                return target.getRunLoggingLevel();
            }
            case "scheduledexecutorservice": 
            case "scheduledExecutorService": {
                return target.getScheduledExecutorService();
            }
            case "scheduler": {
                return target.getScheduler();
            }
            case "schedulerproperties": 
            case "schedulerProperties": {
                return target.getSchedulerProperties();
            }
            case "sendemptymessagewhenidle": 
            case "sendEmptyMessageWhenIdle": {
                return target.isSendEmptyMessageWhenIdle();
            }
            case "serviceclient": 
            case "serviceClient": {
                return target.getConfiguration().getServiceClient();
            }
            case "sourceblobaccesskey": 
            case "sourceBlobAccessKey": {
                return target.getConfiguration().getSourceBlobAccessKey();
            }
            case "startscheduler": 
            case "startScheduler": {
                return target.isStartScheduler();
            }
            case "timeunit": 
            case "timeUnit": {
                return target.getTimeUnit();
            }
            case "timeout": {
                return target.getConfiguration().getTimeout();
            }
            case "usefixeddelay": 
            case "useFixedDelay": {
                return target.isUseFixedDelay();
            }
        }
        return null;
    }

    @Override
    public Object getCollectionValueType(Object target, String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "schedulerproperties": 
            case "schedulerProperties": {
                return Object.class;
            }
        }
        return null;
    }
}

