/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.blob.operations;

import com.azure.core.util.Context;
import com.azure.storage.blob.changefeed.BlobChangefeedClient;
import com.azure.storage.blob.changefeed.models.BlobChangefeedEvent;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.camel.Exchange;
import org.apache.camel.component.azure.storage.blob.BlobConfigurationOptionsProxy;
import org.apache.camel.component.azure.storage.blob.operations.BlobOperationResponse;
import org.apache.camel.util.ObjectHelper;

public class BlobChangeFeedOperations {
    private final BlobChangefeedClient client;
    private final BlobConfigurationOptionsProxy configurationOptionsProxy;

    public BlobChangeFeedOperations(BlobChangefeedClient client, BlobConfigurationOptionsProxy configurationOptionsProxy) {
        ObjectHelper.notNull(client, "client cannot be null");
        this.client = client;
        this.configurationOptionsProxy = configurationOptionsProxy;
    }

    public BlobOperationResponse getEvents(Exchange exchange) {
        OffsetDateTime startTime = this.configurationOptionsProxy.getChangeFeedStartTime(exchange);
        OffsetDateTime endTime = this.configurationOptionsProxy.getChangeFeedEndTime(exchange);
        Context context = this.configurationOptionsProxy.getChangeFeedContext(exchange);
        if (ObjectHelper.isEmpty(startTime) || ObjectHelper.isEmpty(endTime)) {
            return BlobOperationResponse.create(this.getEvents());
        }
        return BlobOperationResponse.create(this.getEvents(startTime, endTime, context));
    }

    private List<BlobChangefeedEvent> getEvents() {
        return this.client.getEvents().stream().collect(Collectors.toList());
    }

    private List<BlobChangefeedEvent> getEvents(OffsetDateTime startTime, OffsetDateTime endTime, Context context) {
        return this.client.getEvents(startTime, endTime, context).stream().collect(Collectors.toList());
    }
}

