/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.policy;

import com.azure.core.credential.AzureKeyCredential;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.util.logging.ClientLogger;
import java.util.Objects;
import reactor.core.publisher.Mono;

public final class AzureKeyCredentialPolicy
implements HttpPipelinePolicy {
    private final ClientLogger logger = new ClientLogger(AzureKeyCredentialPolicy.class);
    private final String name;
    private final AzureKeyCredential credential;

    public AzureKeyCredentialPolicy(String name, AzureKeyCredential credential) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        Objects.requireNonNull(name, "'name' cannot be null.");
        if (name.isEmpty()) {
            throw this.logger.logExceptionAsError(new IllegalArgumentException("'name' cannot be empty."));
        }
        this.name = name;
        this.credential = credential;
    }

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        if ("http".equals(context.getHttpRequest().getUrl().getProtocol())) {
            return Mono.error(new IllegalStateException("Key credentials require HTTPS to prevent leaking the key."));
        }
        context.getHttpRequest().setHeader(this.name, this.credential.getKey());
        return next.process();
    }
}

