/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.rest;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.implementation.ReflectionUtilsApi;
import com.azure.core.implementation.serializer.HttpResponseDecoder;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import reactor.core.publisher.Mono;

final class ResponseConstructorsCache {
    private static final String THREE_PARAM_ERROR = "Failed to deserialize 3-parameter response.";
    private static final String FOUR_PARAM_ERROR = "Failed to deserialize 4-parameter response.";
    private static final String FIVE_PARAM_ERROR = "Failed to deserialize 5-parameter response.";
    private static final String INVALID_PARAM_COUNT = "Response constructor with expected parameters not found.";
    private static final Map<Class<?>, MethodHandle> CACHE = new ConcurrentHashMap();
    private final ClientLogger logger = new ClientLogger(ResponseConstructorsCache.class);

    ResponseConstructorsCache() {
    }

    MethodHandle get(Class<? extends Response<?>> responseClass) {
        return CACHE.computeIfAbsent(responseClass, this::locateResponseConstructor);
    }

    private MethodHandle locateResponseConstructor(Class<?> responseClass) {
        MethodHandles.Lookup lookupToUse;
        try {
            lookupToUse = ReflectionUtilsApi.INSTANCE.getLookupToUse(responseClass);
        }
        catch (Throwable t) {
            throw this.logger.logExceptionAsError(new RuntimeException(t));
        }
        Constructor<?>[] constructors = responseClass.getDeclaredConstructors();
        Arrays.sort(constructors, Comparator.comparing(Constructor::getParameterCount, (a, b) -> b - a));
        for (Constructor<?> constructor : constructors) {
            int paramCount = constructor.getParameterCount();
            if (paramCount < 3 || paramCount > 5) continue;
            try {
                return lookupToUse.unreflectConstructor(constructor);
            }
            catch (Throwable t) {
                throw this.logger.logExceptionAsError(new RuntimeException(t));
            }
        }
        return null;
    }

    Mono<Response<?>> invoke(MethodHandle handle, HttpResponseDecoder.HttpDecodedResponse decodedResponse, Object bodyAsObject) {
        HttpResponse httpResponse = decodedResponse.getSourceResponse();
        HttpRequest httpRequest = httpResponse.getRequest();
        int responseStatusCode = httpResponse.getStatusCode();
        HttpHeaders responseHeaders = httpResponse.getHeaders();
        int paramCount = handle.type().parameterCount();
        switch (paramCount) {
            case 3: {
                return ResponseConstructorsCache.constructResponse(handle, THREE_PARAM_ERROR, this.logger, httpRequest, responseStatusCode, responseHeaders);
            }
            case 4: {
                return ResponseConstructorsCache.constructResponse(handle, FOUR_PARAM_ERROR, this.logger, httpRequest, responseStatusCode, responseHeaders, bodyAsObject);
            }
            case 5: {
                return ResponseConstructorsCache.constructResponse(handle, FIVE_PARAM_ERROR, this.logger, httpRequest, responseStatusCode, responseHeaders, bodyAsObject, decodedResponse.getDecodedHeaders());
            }
        }
        return FluxUtil.monoError(this.logger, new IllegalStateException(INVALID_PARAM_COUNT));
    }

    private static Mono<Response<?>> constructResponse(MethodHandle handle, String exceptionMessage, ClientLogger logger, Object ... params) {
        return Mono.defer(() -> {
            try {
                return Mono.just((Response)handle.invokeWithArguments(params));
            }
            catch (Throwable throwable) {
                return FluxUtil.monoError(logger, new RuntimeException(exceptionMessage, throwable));
            }
        });
    }
}

